/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TabletServerGivesUpIT
extends ConfigurableMacBase {
    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.useMiniDFS(true);
        cfg.setNumTservers(1);
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "10s");
        cfg.setProperty(Property.TSERV_WALOG_TOLERATED_CREATION_FAILURES, "10");
        cfg.setProperty(Property.TSERV_WALOG_TOLERATED_WAIT_INCREMENT, "0s");
        cfg.setProperty(Property.TSERV_WALOG_TOLERATED_MAXIMUM_WAIT_DURATION, "0s");
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Test
    public void test() throws Exception {
        final Connector conn = this.getConnector();
        Assert.assertEquals((long)1L, (long)conn.instanceOperations().getTabletServers().size());
        final String tableName = this.getUniqueNames(1)[0];
        conn.tableOperations().create(tableName);
        this.cluster.getMiniDfs().shutdown();
        final AtomicReference ex = new AtomicReference();
        Thread splitter = new Thread(){

            @Override
            public void run() {
                try {
                    TreeSet<Text> splits = new TreeSet<Text>();
                    splits.add(new Text("X"));
                    conn.tableOperations().addSplits(tableName, splits);
                }
                catch (Exception e) {
                    ex.set(e);
                }
            }
        };
        splitter.start();
        while (conn.instanceOperations().getTabletServers().size() == 1) {
            UtilWaitThread.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
    }
}

