/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.beust.jcommander.Parameter;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.tabletserver.thrift.TDurability;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.cli.ClientOpts;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.hadoop.io.Text;

public class WrongTabletTest {
    public static void main(String[] args) {
        final Opts opts = new Opts();
        opts.parseArgs(WrongTabletTest.class.getName(), args, new Object[0]);
        HostAndPort location = HostAndPort.fromString((String)opts.location);
        Instance inst = opts.getInstance();
        ServerConfigurationFactory conf = new ServerConfigurationFactory(inst);
        AccumuloServerContext context = new AccumuloServerContext(conf){

            public synchronized Credentials getCredentials() {
                try {
                    return new Credentials(opts.getPrincipal(), opts.getToken());
                }
                catch (AccumuloSecurityException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        try {
            TabletClientService.Client client = ThriftUtil.getTServerClient((HostAndPort)location, (ClientContext)context);
            Mutation mutation = new Mutation(new Text("row_0003750001"));
            mutation.putDelete(new Text("colf"), new Text("colq"));
            client.update(Tracer.traceInfo(), context.rpcCreds(), new KeyExtent("!!", null, new Text("row_0003750000")).toThrift(), mutation.toThrift(), TDurability.DEFAULT);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class Opts
    extends ClientOpts {
        @Parameter(names={"--location"}, required=true)
        String location;

        Opts() {
        }
    }
}

