/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.ArrayList;
import java.util.Random;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.hadoop.io.Text;
import org.junit.Test;

public class FateStarvationIT
extends AccumuloClusterHarness {
    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Test
    public void run() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        Connector c = this.getConnector();
        c.tableOperations().create(tableName);
        c.tableOperations().addSplits(tableName, TestIngest.getSplitPoints(0L, 100000L, 50L));
        TestIngest.Opts opts = new TestIngest.Opts();
        opts.random = 89;
        opts.timestamp = 7L;
        opts.dataSize = 50;
        opts.rows = 100000;
        opts.cols = 1;
        opts.setTableName(tableName);
        ClientConfiguration clientConf = cluster.getClientConfig();
        if (clientConf.hasSasl()) {
            opts.updateKerberosCredentials(clientConf);
        } else {
            opts.setPrincipal(FateStarvationIT.getAdminPrincipal());
        }
        TestIngest.ingest(c, opts, new BatchWriterOpts());
        c.tableOperations().flush(tableName, null, null, true);
        ArrayList<Text> splits = new ArrayList<Text>(TestIngest.getSplitPoints(0L, 100000L, 67L));
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            int idx1 = rand.nextInt(splits.size() - 1);
            int idx2 = rand.nextInt(splits.size() - (idx1 + 1)) + idx1 + 1;
            c.tableOperations().compact(tableName, (Text)splits.get(idx1), (Text)splits.get(idx2), false, false);
        }
        c.tableOperations().offline(tableName);
        FunctionalTestUtils.assertNoDanglingFateLocks(this.getConnector().getInstance(), FateStarvationIT.getCluster());
    }
}

