/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Iterator;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.functional.SlowIterator;
import org.junit.Assert;
import org.junit.Test;

public class ScannerIT
extends AccumuloClusterHarness {
    @Override
    protected int defaultTimeoutSeconds() {
        return 60;
    }

    @Test
    public void testScannerReadaheadConfiguration() throws Exception {
        String table = this.getUniqueNames(1)[0];
        Connector c = this.getConnector();
        c.tableOperations().create(table);
        BatchWriter bw = c.createBatchWriter(table, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"a");
        for (int i = 0; i < 10; ++i) {
            m.put((CharSequence)Integer.toString(i), (CharSequence)"", (CharSequence)"");
        }
        bw.addMutation(m);
        bw.close();
        Scanner s = c.createScanner(table, new Authorizations());
        IteratorSetting cfg = new IteratorSetting(100, SlowIterator.class);
        SlowIterator.setSeekSleepTime(cfg, 100L);
        s.addScanIterator(cfg);
        s.setReadaheadThreshold(Long.MAX_VALUE);
        s.setBatchSize(1);
        s.setRange(new Range());
        Iterator iterator = s.iterator();
        long nanosWithWait = 0L;
        long startTime = System.nanoTime();
        while (iterator.hasNext()) {
            nanosWithWait += System.nanoTime() - startTime;
            UtilWaitThread.sleep((long)100L);
            iterator.next();
            startTime = System.nanoTime();
        }
        nanosWithWait += System.nanoTime() - startTime;
        s = c.createScanner(table, new Authorizations());
        s.addScanIterator(cfg);
        s.setRange(new Range());
        s.setBatchSize(1);
        s.setReadaheadThreshold(0L);
        iterator = s.iterator();
        long nanosWithNoWait = 0L;
        startTime = System.nanoTime();
        while (iterator.hasNext()) {
            nanosWithNoWait += System.nanoTime() - startTime;
            UtilWaitThread.sleep((long)100L);
            iterator.next();
            startTime = System.nanoTime();
        }
        Assert.assertTrue((String)("Expected less time to be taken with immediate readahead (" + (nanosWithNoWait += System.nanoTime() - startTime) + ") than without immediate readahead (" + nanosWithWait + ")"), (nanosWithNoWait < nanosWithWait ? 1 : 0) != 0);
    }
}

