/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.security;

import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.security.WalkingSecurity;

public class ChangePass
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        AuthenticationToken token;
        String principal;
        String target = props.getProperty("target");
        String source = props.getProperty("source");
        if (source.equals("system")) {
            principal = WalkingSecurity.get(state, env).getSysUserName();
            token = WalkingSecurity.get(state, env).getSysToken();
        } else {
            principal = WalkingSecurity.get(state, env).getTabUserName();
            token = WalkingSecurity.get(state, env).getTabToken();
        }
        Connector conn = env.getInstance().getConnector(principal, token);
        target = target.equals("table") ? WalkingSecurity.get(state, env).getTabUserName() : WalkingSecurity.get(state, env).getSysUserName();
        boolean targetExists = WalkingSecurity.get(state, env).userExists(target);
        boolean hasPerm = WalkingSecurity.get(state, env).canChangePassword(new Credentials(principal, token).toThrift(env.getInstance()), target);
        Random r = new Random();
        byte[] newPassw = new byte[r.nextInt(50) + 1];
        for (int i = 0; i < newPassw.length; ++i) {
            newPassw[i] = (byte)(r.nextInt(26) + 65 & 0xFF);
        }
        PasswordToken newPass = new PasswordToken(newPassw);
        try {
            conn.securityOperations().changeLocalUserPassword(target, newPass);
        }
        catch (AccumuloSecurityException ae) {
            switch (ae.getSecurityErrorCode()) {
                case PERMISSION_DENIED: {
                    if (hasPerm) {
                        throw new AccumuloException("Change failed when it should have succeeded to change " + target + "'s password", (Throwable)ae);
                    }
                    return;
                }
                case USER_DOESNT_EXIST: {
                    if (targetExists) {
                        throw new AccumuloException("User " + target + " doesn't exist and they SHOULD.", (Throwable)ae);
                    }
                    return;
                }
                case BAD_CREDENTIALS: {
                    if (!WalkingSecurity.get(state, env).userPassTransient(conn.whoami())) {
                        throw new AccumuloException("Bad credentials for user " + conn.whoami());
                    }
                    return;
                }
            }
            throw new AccumuloException("Got unexpected exception", (Throwable)ae);
        }
        WalkingSecurity.get(state, env).changePassword(target, (AuthenticationToken)newPass);
        Thread.sleep(1000L);
        if (!hasPerm) {
            throw new AccumuloException("Password change succeeded when it should have failed for " + source + " changing the password for " + target + ".");
        }
    }
}

