/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.metadata.schema;

import com.google.common.collect.MoreCollectors;
import java.util.NoSuchElementException;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;

public class AmpleImpl
implements Ample {
    private final AccumuloClient client;

    public AmpleImpl(AccumuloClient client) {
        this.client = client;
    }

    @Override
    public TabletMetadata readTablet(KeyExtent extent, Ample.ReadConsistency readConsistency, TabletMetadata.ColumnType ... colsToFetch) {
        TabletsMetadata.Options builder = TabletsMetadata.builder(this.client).forTablet(extent);
        if (colsToFetch.length > 0) {
            builder.fetch(colsToFetch);
        }
        builder.readConsistency(readConsistency);
        TabletsMetadata tablets = builder.build();
        try {
            TabletMetadata tabletMetadata = (TabletMetadata)tablets.stream().collect(MoreCollectors.onlyElement());
            if (tablets != null) {
                tablets.close();
            }
            return tabletMetadata;
        }
        catch (Throwable throwable) {
            try {
                if (tablets != null) {
                    try {
                        tablets.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
    }

    @Override
    public TabletsMetadata.TableOptions readTablets() {
        return TabletsMetadata.builder(this.client);
    }
}

