/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.namespace.create;

import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.namespace.create.NamespaceInfo;
import org.slf4j.LoggerFactory;

class FinishCreateNamespace
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private final NamespaceInfo namespaceInfo;

    public FinishCreateNamespace(NamespaceInfo ti) {
        this.namespaceInfo = ti;
    }

    @Override
    public long isReady(long tid, Manager environment) {
        return 0L;
    }

    @Override
    public Repo<Manager> call(long id, Manager env) {
        Utils.unreserveNamespace(env, this.namespaceInfo.namespaceId, id, true);
        env.getEventCoordinator().event("Created namespace %s ", this.namespaceInfo.namespaceName);
        LoggerFactory.getLogger(FinishCreateNamespace.class).debug("Created table " + String.valueOf(this.namespaceInfo.namespaceId) + " " + this.namespaceInfo.namespaceName);
        return null;
    }

    @Override
    public String getReturn() {
        return this.namespaceInfo.namespaceId.canonical();
    }

    @Override
    public void undo(long tid, Manager env) {
    }
}

