/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.tableImport;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.clientImpl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Namespaces;
import org.apache.accumulo.core.clientImpl.TableOperationsImpl;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.util.tables.TableNameUtil;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.tableImport.CreateImportDir;
import org.apache.accumulo.manager.tableOps.tableImport.ImportedTableInfo;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.store.PropStoreKey;
import org.apache.accumulo.server.conf.store.TablePropKey;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.util.PropUtil;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

class ImportPopulateZookeeper
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private final ImportedTableInfo tableInfo;

    ImportPopulateZookeeper(ImportedTableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public long isReady(long tid, Manager environment) throws Exception {
        return Utils.reserveTable(environment, this.tableInfo.tableId, tid, true, false, TableOperation.IMPORT);
    }

    private Map<String, String> getExportedProps(VolumeManager fs) throws Exception {
        Path path = new Path(this.tableInfo.exportFile);
        try {
            FileSystem ns = fs.getFileSystemByPath(path);
            return TableOperationsImpl.getExportedProps((FileSystem)ns, (Path)path);
        }
        catch (IOException ioe) {
            throw new AcceptableThriftTableOperationException(this.tableInfo.tableId.canonical(), this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Error reading table props from " + String.valueOf(path) + " " + ioe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Manager> call(long tid, Manager env) throws Exception {
        Utils.getTableNameLock().lock();
        try {
            Utils.checkTableNameDoesNotExist(env.getContext(), this.tableInfo.tableName, this.tableInfo.namespaceId, this.tableInfo.tableId, TableOperation.CREATE);
            String namespace = (String)TableNameUtil.qualify((String)this.tableInfo.tableName).getFirst();
            NamespaceId namespaceId = Namespaces.getNamespaceId((ClientContext)env.getContext(), (String)namespace);
            env.getTableManager().addTable(this.tableInfo.tableId, namespaceId, this.tableInfo.tableName);
            env.getContext().clearTableListCache();
        }
        finally {
            Utils.getTableNameLock().unlock();
        }
        VolumeManager volMan = env.getVolumeManager();
        try {
            PropUtil.setProperties((ServerContext)env.getContext(), (PropStoreKey)TablePropKey.of((ServerContext)env.getContext(), (TableId)this.tableInfo.tableId), this.getExportedProps(volMan));
        }
        catch (IllegalStateException ex) {
            throw new AcceptableThriftTableOperationException(this.tableInfo.tableId.canonical(), this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "failed to set table properties");
        }
        return new CreateImportDir(this.tableInfo);
    }

    @Override
    public void undo(long tid, Manager env) throws Exception {
        env.getTableManager().removeTable(this.tableInfo.tableId);
        Utils.unreserveTable(env, this.tableInfo.tableId, tid, true);
        env.getContext().clearTableListCache();
    }
}

