/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.Halt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollectionLogger {
    private static final Logger log = LoggerFactory.getLogger(GarbageCollectionLogger.class);
    private final HashMap<String, Long> prevGcTime = new HashMap();
    private long lastMemorySize = 0L;
    private long gcTimeIncreasedCount = 0L;
    private static long lastMemoryCheckTime = 0L;
    private static final Lock memCheckTimeLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logGCInfo(AccumuloConfiguration conf) {
        memCheckTimeLock.lock();
        try {
            long now = System.currentTimeMillis();
            List<GarbageCollectorMXBean> gcmBeans = ManagementFactory.getGarbageCollectorMXBeans();
            Runtime rt = Runtime.getRuntime();
            StringBuilder sb = new StringBuilder("gc");
            boolean sawChange = false;
            long maxIncreaseInCollectionTime = 0L;
            for (GarbageCollectorMXBean gcBean : gcmBeans) {
                long time;
                Long prevTime = this.prevGcTime.get(gcBean.getName());
                long pt = 0L;
                if (prevTime != null) {
                    pt = prevTime;
                }
                if ((time = gcBean.getCollectionTime()) - pt != 0L) {
                    sawChange = true;
                }
                long increaseInCollectionTime = time - pt;
                sb.append(String.format(" %s=%,.2f(+%,.2f) secs", gcBean.getName(), (double)time / 1000.0, (double)increaseInCollectionTime / 1000.0));
                maxIncreaseInCollectionTime = Math.max(increaseInCollectionTime, maxIncreaseInCollectionTime);
                this.prevGcTime.put(gcBean.getName(), time);
            }
            long mem = rt.freeMemory();
            if (maxIncreaseInCollectionTime == 0L) {
                this.gcTimeIncreasedCount = 0L;
            } else {
                ++this.gcTimeIncreasedCount;
                if (this.gcTimeIncreasedCount > 3L && (double)mem < (double)rt.maxMemory() * 0.05) {
                    log.warn("Running low on memory");
                    this.gcTimeIncreasedCount = 0L;
                }
            }
            if (mem != this.lastMemorySize) {
                sawChange = true;
            }
            String sign = "+";
            if (mem - this.lastMemorySize <= 0L) {
                sign = "";
            }
            sb.append(String.format(" freemem=%,d(%s%,d) totalmem=%,d", mem, sign, mem - this.lastMemorySize, rt.totalMemory()));
            if (sawChange) {
                log.debug(sb.toString());
            }
            long keepAliveTimeout = conf.getTimeInMillis(Property.INSTANCE_ZK_TIMEOUT);
            if (lastMemoryCheckTime > 0L && lastMemoryCheckTime < now) {
                long diff = now - lastMemoryCheckTime;
                if (diff > keepAliveTimeout + 1000L) {
                    log.warn(String.format("GC pause checker not called in a timely fashion. Expected every %.1f seconds but was %.1f seconds since last check", (double)keepAliveTimeout / 1000.0, (double)diff / 1000.0));
                }
                lastMemoryCheckTime = now;
                return;
            }
            if (maxIncreaseInCollectionTime > keepAliveTimeout) {
                Halt.halt((int)-1, (String)"Garbage collection may be interfering with lock keep-alive.  Halting.");
            }
            this.lastMemorySize = mem;
            lastMemoryCheckTime = now;
        }
        finally {
            memCheckTimeLock.unlock();
        }
    }
}

