/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// CamelLoaderApplyConfiguration represents an declarative configuration of the CamelLoader type for use
// with apply.
type CamelLoaderApplyConfiguration struct {
	MavenArtifactApplyConfiguration `json:",inline"`
	Languages                       []string                          `json:"languages,omitempty"`
	Dependencies                    []MavenArtifactApplyConfiguration `json:"dependencies,omitempty"`
	Metadata                        map[string]string                 `json:"metadata,omitempty"`
}

// CamelLoaderApplyConfiguration constructs an declarative configuration of the CamelLoader type for use with
// apply.
func CamelLoader() *CamelLoaderApplyConfiguration {
	return &CamelLoaderApplyConfiguration{}
}

// WithGroupID sets the GroupID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the GroupID field is set to the value of the last call.
func (b *CamelLoaderApplyConfiguration) WithGroupID(value string) *CamelLoaderApplyConfiguration {
	b.GroupID = &value
	return b
}

// WithArtifactID sets the ArtifactID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ArtifactID field is set to the value of the last call.
func (b *CamelLoaderApplyConfiguration) WithArtifactID(value string) *CamelLoaderApplyConfiguration {
	b.ArtifactID = &value
	return b
}

// WithType sets the Type field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Type field is set to the value of the last call.
func (b *CamelLoaderApplyConfiguration) WithType(value string) *CamelLoaderApplyConfiguration {
	b.Type = &value
	return b
}

// WithVersion sets the Version field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Version field is set to the value of the last call.
func (b *CamelLoaderApplyConfiguration) WithVersion(value string) *CamelLoaderApplyConfiguration {
	b.Version = &value
	return b
}

// WithClassifier sets the Classifier field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Classifier field is set to the value of the last call.
func (b *CamelLoaderApplyConfiguration) WithClassifier(value string) *CamelLoaderApplyConfiguration {
	b.Classifier = &value
	return b
}

// WithLanguages adds the given value to the Languages field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Languages field.
func (b *CamelLoaderApplyConfiguration) WithLanguages(values ...string) *CamelLoaderApplyConfiguration {
	for i := range values {
		b.Languages = append(b.Languages, values[i])
	}
	return b
}

// WithDependencies adds the given value to the Dependencies field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Dependencies field.
func (b *CamelLoaderApplyConfiguration) WithDependencies(values ...*MavenArtifactApplyConfiguration) *CamelLoaderApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithDependencies")
		}
		b.Dependencies = append(b.Dependencies, *values[i])
	}
	return b
}

// WithMetadata puts the entries into the Metadata field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Metadata field,
// overwriting an existing map entries in Metadata field with the same key.
func (b *CamelLoaderApplyConfiguration) WithMetadata(entries map[string]string) *CamelLoaderApplyConfiguration {
	if b.Metadata == nil && len(entries) > 0 {
		b.Metadata = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.Metadata[k] = v
	}
	return b
}
