/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.transform;

import java.util.Objects;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.Transformation;

public final class RTBoundValidator
extends Transformation<UnfilteredRowIterator> {
    private final Stage stage;
    private final boolean enforceIsClosed;

    private RTBoundValidator(Stage stage, boolean enforceIsClosed) {
        this.stage = stage;
        this.enforceIsClosed = enforceIsClosed;
    }

    public static UnfilteredPartitionIterator validate(UnfilteredPartitionIterator partitions, Stage stage, boolean enforceIsClosed) {
        return Transformation.apply(partitions, new RTBoundValidator(stage, enforceIsClosed));
    }

    public static UnfilteredRowIterator validate(UnfilteredRowIterator partition, Stage stage, boolean enforceIsClosed) {
        return Transformation.apply(partition, new RowsTransformation(stage, partition, enforceIsClosed));
    }

    @Override
    public UnfilteredRowIterator applyToPartition(UnfilteredRowIterator partition) {
        return Transformation.apply(partition, new RowsTransformation(this.stage, partition, this.enforceIsClosed));
    }

    private static final class RowsTransformation
    extends Transformation {
        private final Stage stage;
        private final boolean enforceIsClosed;
        private final UnfilteredRowIterator partition;
        private DeletionTime openMarkerDeletionTime;

        private RowsTransformation(Stage stage, UnfilteredRowIterator partition, boolean enforceIsClosed) {
            this.stage = stage;
            this.partition = partition;
            this.enforceIsClosed = enforceIsClosed;
        }

        @Override
        public RangeTombstoneMarker applyToMarker(RangeTombstoneMarker marker) {
            if (null == this.openMarkerDeletionTime) {
                if (marker.isClose(this.partition.isReverseOrder())) {
                    throw this.ise("unexpected end bound or boundary " + marker.toString(this.partition.metadata()));
                }
            } else {
                if (!marker.isClose(this.partition.isReverseOrder())) {
                    throw this.ise("start bound followed by another start bound " + marker.toString(this.partition.metadata()));
                }
                DeletionTime deletionTime = marker.closeDeletionTime(this.partition.isReverseOrder());
                if (!deletionTime.equals(this.openMarkerDeletionTime)) {
                    throw this.ise("open marker and close marker have different deletion times, close=" + deletionTime);
                }
                this.openMarkerDeletionTime = null;
            }
            if (marker.isOpen(this.partition.isReverseOrder())) {
                this.openMarkerDeletionTime = marker.openDeletionTime(this.partition.isReverseOrder());
            }
            return marker;
        }

        @Override
        public void onPartitionClose() {
            if (this.enforceIsClosed && null != this.openMarkerDeletionTime) {
                throw this.ise("expected all RTs to be closed, but the last one is open");
            }
        }

        private IllegalStateException ise(String why) {
            throw new IllegalStateException(this.message(why));
        }

        private String message(String why) {
            return String.format("%s UnfilteredRowIterator for %s (key: %s omdt: [%s]) has an illegal RT bounds sequence: %s", new Object[]{this.stage, this.partition.metadata(), this.partition.metadata().partitionKeyType.getString(this.partition.partitionKey().getKey()), Objects.toString(this.openMarkerDeletionTime, "not present"), why});
        }
    }

    public static enum Stage {
        MEMTABLE,
        SSTABLE,
        MERGED,
        PURGED,
        PROCESSED;

    }
}

