/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.tries;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cassandra.db.tries.Trie;
import org.apache.cassandra.db.tries.TriePathReconstructor;
import org.apache.cassandra.utils.bytecomparable.ByteComparable;

public abstract class TrieEntriesIterator<T, V>
extends TriePathReconstructor
implements Iterator<V> {
    private final Trie.Cursor<T> cursor;
    T next;
    boolean gotNext;

    protected TrieEntriesIterator(Trie<T> trie) {
        this.cursor = trie.cursor();
        assert (this.cursor.depth() == 0);
        this.next = this.cursor.content();
        this.gotNext = this.next != null;
    }

    @Override
    public boolean hasNext() {
        if (!this.gotNext) {
            this.next = this.cursor.advanceToContent(this);
            this.gotNext = true;
        }
        return this.next != null;
    }

    @Override
    public V next() {
        this.gotNext = false;
        T v = this.next;
        this.next = null;
        return this.mapContent(v, this.keyBytes, this.keyPos);
    }

    protected abstract V mapContent(T var1, byte[] var2, int var3);

    static <T> Map.Entry<ByteComparable, T> toEntry(T content, byte[] bytes, int byteLength) {
        return new AbstractMap.SimpleImmutableEntry<ByteComparable, T>(TrieEntriesIterator.toByteComparable(bytes, byteLength), content);
    }

    static class AsEntries<T>
    extends TrieEntriesIterator<T, Map.Entry<ByteComparable, T>> {
        public AsEntries(Trie<T> trie) {
            super(trie);
        }

        @Override
        protected Map.Entry<ByteComparable, T> mapContent(T content, byte[] bytes, int byteLength) {
            return AsEntries.toEntry(content, bytes, byteLength);
        }
    }
}

