/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common.idltypes;

import java.io.PrintWriter;
import org.apache.cxf.tools.corba.common.idltypes.IdlDefnImplBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlScopeBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlScopedName;
import org.apache.cxf.tools.corba.common.idltypes.IdlType;

public final class IdlPrimitive
extends IdlDefnImplBase
implements IdlType {
    static final short MINIMUM = 1;
    static final short LONG = 1;
    static final short ULONG = 2;
    static final short LONGLONG = 3;
    static final short ULONGLONG = 4;
    static final short SHORT = 5;
    static final short USHORT = 6;
    static final short FLOAT = 7;
    static final short DOUBLE = 8;
    static final short LONGDOUBLE = 9;
    static final short CHAR = 10;
    static final short WCHAR = 11;
    static final short BOOLEAN = 12;
    static final short OCTET = 13;
    static final short ANY = 14;
    static final short MAXIMUM = 15;
    static final short DATETIME = 15;
    private String wsdlName;
    private short type;

    private IdlPrimitive(IdlScopeBase parent, String name, String wsdlFileName, short typeValue) {
        super(parent, name);
        this.wsdlName = wsdlFileName;
        this.type = typeValue;
    }

    public static IdlPrimitive create(IdlScopeBase parent, short type) {
        String name = null;
        String wsdlName = null;
        switch (type) {
            case 1: {
                name = "long";
                wsdlName = "long";
                break;
            }
            case 2: {
                name = "unsigned long";
                wsdlName = "ulong";
                break;
            }
            case 3: {
                name = "long long";
                wsdlName = "longlong";
                break;
            }
            case 4: {
                name = "unsigned long long";
                wsdlName = "ulonglong";
                break;
            }
            case 5: {
                name = "short";
                wsdlName = "short";
                break;
            }
            case 6: {
                name = "unsigned short";
                wsdlName = "ushort";
                break;
            }
            case 7: {
                name = "float";
                wsdlName = "float";
                break;
            }
            case 8: {
                name = "double";
                wsdlName = "double";
                break;
            }
            case 9: {
                name = "long double";
                wsdlName = "longdouble";
                break;
            }
            case 10: {
                name = "char";
                wsdlName = "char";
                break;
            }
            case 11: {
                name = "wchar";
                wsdlName = "wchar";
                break;
            }
            case 12: {
                name = "boolean";
                wsdlName = "boolean";
                break;
            }
            case 13: {
                name = "octet";
                wsdlName = "octet";
                break;
            }
            case 14: {
                name = "any";
                wsdlName = "any";
                break;
            }
            case 15: {
                name = "TimeBase::UtcT";
                wsdlName = "dateTime";
                break;
            }
        }
        return new IdlPrimitive(parent, name, wsdlName, type);
    }

    @Override
    public String fullName() {
        return this.localName();
    }

    @Override
    public String fullName(IdlScopedName rel) {
        return this.localName();
    }

    @Override
    public IdlScopedName scopeName() {
        return null;
    }

    short primitiveType() {
        return this.type;
    }

    String wsdlName() {
        return this.wsdlName;
    }

    @Override
    public void write(PrintWriter pw) {
        pw.print(this.localName());
    }
}

