/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.JDBC;

public class DeadlockModeTest
extends BaseJDBCTestCase {
    private static final int THREAD_COUNT = 20;
    private Object syncObject = new Object();
    private int startedCount = 0;
    private LinkedList<Exception> listExceptions = new LinkedList();

    public DeadlockModeTest(String string) {
        super(string);
    }

    public void testThreadsUpdatingTable() throws Exception {
        Thread[] threadArray = new Thread[20];
        this.createThreads(threadArray);
        this.waitForThreads(threadArray);
        if (!this.listExceptions.isEmpty()) {
            DeadlockModeTest.fail((String)("FAIL - " + this.listExceptions.size() + " threads threw exceptions"));
        }
    }

    private void createThreads(Thread[] threadArray) throws SQLException {
        for (int i = 0; i < 20; ++i) {
            final Connection connection = this.openDefaultConnection();
            threadArray[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    DeadlockModeTest.this.threadWorker(connection);
                }
            });
            threadArray[i].start();
        }
    }

    private void waitForThreads(Thread[] threadArray) throws Exception {
        for (int i = 0; i < 20; ++i) {
            try {
                threadArray[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                DeadlockModeTest.assertNull((String)"FAIL - Exception thrown waiting for the threads", (Object)interruptedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadWorker(Connection connection) {
        try {
            Object object = this.syncObject;
            synchronized (object) {
                ++this.startedCount;
                this.syncObject.notifyAll();
                while (this.startedCount < 20) {
                    this.syncObject.wait();
                }
            }
            object = connection.createStatement();
            object.executeUpdate("update t set i = 456 where i = 456");
            connection.setAutoCommit(false);
            object.execute("set isolation serializable");
            for (int i = 0; i < 100; ++i) {
                object.executeUpdate("update t set i = 456 where i = 456");
                connection.commit();
            }
            connection.close();
        }
        catch (Exception exception) {
            Object object = this.syncObject;
            synchronized (object) {
                this.listExceptions.add(exception);
            }
        }
    }

    protected static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(DeadlockModeTest.class);
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts((Test)baseTestSuite, 2, 4)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create table t (i int)");
                statement.executeUpdate("insert into t values (1956)");
                statement.executeUpdate("insert into t values (180)");
                statement.executeUpdate("insert into t values (3)");
            }
        };
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("DeadlockModeTest ");
        baseTestSuite.addTest(DeadlockModeTest.baseSuite("DeadlockModeTest:embedded"));
        if (JDBC.vmSupportsJDBC3()) {
            baseTestSuite.addTest(Decorator.encryptedDatabase(DeadlockModeTest.baseSuite("DeadlockModeTest:encrypted")));
        }
        return baseTestSuite;
    }
}

