/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class PrivilegedFileOpsForTests {
    public static long length(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return file.length();
    }

    public static String getAbsolutePath(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return file.getAbsolutePath();
    }

    public static URI toURI(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return file.toURI();
    }

    public static File createTempFile(String string, String string2, File file) throws IOException {
        return File.createTempFile(string, string2, file);
    }

    public static FileInputStream getFileInputStream(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return new FileInputStream(file);
    }

    public static boolean exists(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return file.exists();
    }

    public static boolean delete(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return file.delete();
    }

    public static boolean mkdir(File file) {
        return file.mkdir();
    }

    public static boolean setReadable(File file, boolean bl, boolean bl2) {
        return file.setReadable(bl, bl2);
    }

    public static boolean setReadOnly(File file) {
        return file.setReadOnly();
    }

    public static FileReader getFileReader(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return new FileReader(file);
    }

    public static FileWriter getFileWriter(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return new FileWriter(file);
    }

    public static File[] listFiles(File file) {
        return file.listFiles();
    }

    public static void copy(File file, File file2) throws IOException {
        PrivilegedFileOpsForTests.recursiveCopy(file, file2);
    }

    private static void recursiveCopy(File file, File file2) throws IOException {
        byte[] byArray = new byte[32768];
        if (file.isFile()) {
            PrivilegedFileOpsForTests.copySingleFile(file, file2, byArray);
            return;
        }
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file3 = new File(file, stringArray[i]);
                File file4 = new File(file2, stringArray[i]);
                if (file3.isDirectory()) {
                    PrivilegedFileOpsForTests.copy(file3, file4);
                    continue;
                }
                PrivilegedFileOpsForTests.copySingleFile(file3, file4, byArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copySingleFile(File file, File file2, byte[] byArray) throws IOException {
        File file3;
        if (byArray == null) {
            byArray = new byte[32768];
        }
        if ((file3 = file2.getParentFile()) != null && !file3.exists()) {
            file2.getParentFile().mkdirs();
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        try {
            int n;
            while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
        finally {
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
        }
    }

    public static FileOutputStream getFileOutputStream(File file) throws FileNotFoundException {
        return PrivilegedFileOpsForTests.getFileOutputStream(file, false);
    }

    public static FileOutputStream getFileOutputStream(File file, boolean bl) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be <null>");
        }
        return new FileOutputStream(file, bl);
    }

    public static File[] persistentRecursiveDelete(File file) throws FileNotFoundException {
        if (!PrivilegedFileOpsForTests.exists(file)) {
            throw new FileNotFoundException(PrivilegedFileOpsForTests.getAbsolutePath(file));
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        PrivilegedFileOpsForTests.deleteRecursively(file, arrayList);
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private static boolean deleteRecursively(File file, List<File> list) {
        File[] fileArray;
        boolean bl = true;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    bl &= PrivilegedFileOpsForTests.deleteRecursively(file2, list);
                    continue;
                }
                bl &= PrivilegedFileOpsForTests.internalDelete(file2, list);
            }
        }
        return bl &= PrivilegedFileOpsForTests.internalDelete(file, list);
    }

    private static boolean internalDelete(File file, List<File> list) {
        boolean bl = file.delete();
        if (!bl) {
            list.add(file);
        }
        return bl;
    }

    public static String getFileInfo(File file) {
        if (!file.exists()) {
            return "(non-existant)";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(isDir=").append(file.isDirectory()).append(", canRead=").append(file.canRead()).append(", canWrite=").append(file.canWrite()).append(", size=").append(file.length()).append(')');
        return stringBuilder.toString();
    }
}

