/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DMDBugsTest
extends BaseJDBCTestCase {
    public DMDBugsTest(String string) {
        super(string);
    }

    public void testDerby3000() throws SQLException, IOException {
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE APP.TAB (i int)");
        statement.executeUpdate("CREATE VIEW  APP.V  as SELECT * FROM TAB");
        statement.executeUpdate("CREATE SYNONYM TSYN FOR APP.TAB");
        String[] stringArray = new String[]{"SYNONYM", "TABLE", "VIEW", "GLOBAL TEMPORARY"};
        ResultSet resultSet = databaseMetaData.getTables("%", "%", "%", stringArray);
        JDBC.assertFullResultSet(resultSet, new String[][]{{"", "APP", "TSYN", "SYNONYM", "", null, null, null, null, null}, {"", "APP", "TAB", "TABLE", "", null, null, null, null, null}, {"", "APP", "V", "VIEW", "", null, null, null, null, null}});
        resultSet = databaseMetaData.getTables("%", "%", "%", new String[]{"GLOBAL TEMPORARY"});
        JDBC.assertEmpty(resultSet);
        resultSet = databaseMetaData.getTables("%", "%", "%", new String[]{"VIEW"});
        JDBC.assertUnorderedResultSet(resultSet, new String[][]{{"", "APP", "V", "VIEW", "", null, null, null, null, null}});
        resultSet = databaseMetaData.getTables("%", "%", "%", new String[]{"TABLE"});
        JDBC.assertUnorderedResultSet(resultSet, new String[][]{{"", "APP", "TAB", "TABLE", "", null, null, null, null, null}});
        resultSet = databaseMetaData.getTables("%", "%", "%", new String[]{"SYNONYM"});
        JDBC.assertUnorderedResultSet(resultSet, new String[][]{{"", "APP", "TSYN", "SYNONYM", "", null, null, null, null, null}});
        resultSet = databaseMetaData.getTables("%", "%", "%", new String[]{"SYSTEM TABLE"});
        DMDBugsTest.assertEquals((int)23, (int)JDBC.assertDrainResults(resultSet));
        statement.executeUpdate("DROP VIEW APP.V");
        statement.executeUpdate("DROP TABLE APP.TAB");
        statement.executeUpdate("DROP SYNONYM APP.TSYN");
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("DMDBugsTest");
        baseTestSuite.addTest(TestConfiguration.defaultSuite(DMDBugsTest.class));
        return baseTestSuite;
    }
}

