/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Formatters;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class ColumnDefaultsTest
extends BaseJDBCTestCase {
    public ColumnDefaultsTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ColumnDefaultsTest Test");
        baseTestSuite.addTest(TestConfiguration.defaultSuite(ColumnDefaultsTest.class));
        return baseTestSuite;
    }

    public void testNegativeTestsForColumnDefaults() throws Exception {
        Statement statement = this.createStatement();
        ColumnDefaultsTest.assertStatementError("42X01", statement, "create table neg(c1 int default ?)");
        ColumnDefaultsTest.assertStatementError("42X01", statement, "create table neg(c1 int, c2 int default c1)");
        ColumnDefaultsTest.assertStatementError("42X01", statement, "create table neg(c1 int default (values 1))");
        ColumnDefaultsTest.assertStatementError("42821", statement, "create table neg(c1 date default 1)");
        statement.executeUpdate("create table neg(c1 int, c2 date default '1')");
        ColumnDefaultsTest.assertStatementError("22007", statement, " insert into neg (c1) values 1");
        statement.executeUpdate(" drop table neg");
        statement.executeUpdate("CREATE FUNCTION ASDF (DATA DOUBLE) RETURNS DOUBLE EXTERNAL NAME 'java.lang.Math.sin' LANGUAGE JAVA PARAMETER STYLE JAVA");
        ColumnDefaultsTest.assertStatementError("42894", statement, " create table neg(c1 int default asdf(0))");
        ColumnDefaultsTest.assertStatementError("42Y55", statement, " drop table neg");
        ColumnDefaultsTest.assertStatementError("42Y85", statement, "values default");
        ColumnDefaultsTest.assertStatementError("42Y85", statement, " values 1, default");
        statement.executeUpdate("create table neg(c1 date)");
        ColumnDefaultsTest.assertStatementError("42X01", statement, " alter table neg modify x default null");
        ColumnDefaultsTest.assertStatementError("42821", statement, " alter table neg add column x date default 1");
        statement.executeUpdate("alter table neg add column x date default '1'");
        ColumnDefaultsTest.assertStatementError("22007", statement, " insert into neg (c1) values default");
        statement.executeUpdate(" drop table neg");
        statement.executeUpdate("create table neg(c1 int default 10)");
        ColumnDefaultsTest.assertStatementError("42X06", statement, " insert into neg values (1, default)");
        ColumnDefaultsTest.assertStatementError("42802", statement, " insert into neg values (default, 1)");
        ColumnDefaultsTest.assertStatementError("42Y85", statement, " insert into neg values (default) union values (default)");
        ColumnDefaultsTest.assertStatementError("42Y85", statement, " insert into neg values (default) except values (default)");
        ColumnDefaultsTest.assertStatementError("42Y85", statement, " insert into neg select * from (values default) t");
        statement.executeUpdate(" drop table neg");
        statement.executeUpdate("drop function asdf");
        this.rollback();
        statement.close();
    }

    public void testPositiveTestsForColumnDefaults() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t1(c1 int, c2 int with default 5, c3 date default current_date, c4 int)");
        statement.executeUpdate("insert into t1 (c1) values 1");
        statement.executeUpdate(" insert into t1 (c4) values 4");
        ResultSet resultSet = statement.executeQuery("select c1, c2, c4 from t1");
        String[] stringArray = new String[]{"C1", "C2", "C4"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"1", "5", null}, {null, "5", "4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select c1, c2, c4 from t1 where c3 = current_date");
        stringArray = new String[]{"C1", "C2", "C4"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "5", null}, {null, "5", "4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        ColumnDefaultsTest.assertUpdateCount(statement, 2, "update t1 set c1 = default");
        resultSet = statement.executeQuery(" select c1, c2, c4 from t1 where c3 = current_date");
        stringArray = new String[]{"C1", "C2", "C4"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{null, "5", null}, {null, "5", "4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        ColumnDefaultsTest.assertUpdateCount(statement, 2, "update t1 set c2 = 7");
        resultSet = statement.executeQuery(" select c2 from t1");
        stringArray = new String[]{"C2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"7"}, {"7"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        ColumnDefaultsTest.assertUpdateCount(statement, 2, " update t1 set c2 = default");
        resultSet = statement.executeQuery(" select c2 from t1");
        stringArray = new String[]{"C2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"5"}, {"5"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        ColumnDefaultsTest.assertUpdateCount(statement, 2, "delete from t1");
        statement.executeUpdate(" insert into t1 values (5, default, '1999-09-09', default)");
        statement.executeUpdate(" insert into t1 values (default, 6, default, 5)");
        statement.executeUpdate(" insert into t1 values (default, 6, default, 5), (7, default, '1997-07-07', 3)");
        resultSet = statement.executeQuery(" select c1, c2, c4 from t1 where c3 = current_date");
        stringArray = new String[]{"C1", "C2", "C4"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{null, "6", "5"}, {null, "6", "5"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select c1, c2, c4 from t1 where c3 <> current_date");
        stringArray = new String[]{"C1", "C2", "C4"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"5", "5", null}, {"7", "5", "3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        ColumnDefaultsTest.assertUpdateCount(statement, 4, " delete from t1");
        statement.executeUpdate(" insert into t1 (c1, c3, c4) values (5, '1999-09-09', default)");
        statement.executeUpdate(" insert into t1 (c1, c3, c4) values (default, default, 5)");
        statement.executeUpdate(" insert into t1 (c1, c3, c4) values (default, default, default)");
        statement.executeUpdate(" insert into t1 (c1, c3, c4) values (default, default, 5), (7, '1997-07-07', 3)");
        resultSet = statement.executeQuery(" select c1, c2, c4 from t1 where c3 = current_date");
        stringArray = new String[]{"C1", "C2", "C4"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{null, "5", "5"}, {null, "5", null}, {null, "5", "5"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select c1, c2, c4 from t1 where c3 <> current_date");
        stringArray = new String[]{"C1", "C2", "C4"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"5", "5", null}, {"7", "5", "3"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("create table \"x1\" (\"c1\" int)");
        statement.executeUpdate(" insert into \"x1\" values 1");
        statement.executeUpdate(" alter table \"x1\" add column \"c2\" char(1) default 'x'");
        resultSet = statement.executeQuery(" select * from \"x1\"");
        stringArray = new String[]{"c1", "c2"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "x"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("create schema \"otherschema\"");
        statement.executeUpdate(" create table \"otherschema\".\"y1\" (\"c11\" int)");
        statement.executeUpdate(" insert into \"otherschema\".\"y1\" values 2");
        statement.executeUpdate(" alter table \"otherschema\".\"y1\" add column \"c22\" char(1) default 'y'");
        resultSet = statement.executeQuery(" select * from \"otherschema\".\"y1\"");
        stringArray = new String[]{"c11", "c22"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"2", "y"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("create table t7(c1 int default 10)");
        statement.executeUpdate(" insert into t7 values (default)");
        resultSet = statement.executeQuery(" select * from t7");
        stringArray = new String[]{"C1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"10"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("delete from t7");
        statement.executeUpdate("insert into t7 values 1, default");
        resultSet = statement.executeQuery(" select * from t7");
        objectArray = new String[][]{{"1"}, {"10"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate(" drop table t1");
        statement.executeUpdate(" drop table t7");
        statement.executeUpdate(" drop table \"x1\"");
        statement.executeUpdate(" drop table \"otherschema\".\"y1\"");
        statement.executeUpdate(" drop schema \"otherschema\" restrict");
        this.rollback();
        statement.close();
    }

    public void testJira331() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t_331 (a int not null, b int default 0, unique (a))");
        statement.executeUpdate(" insert into t_331 values (4, default)");
        ColumnDefaultsTest.assertStatementError("23505", statement, " insert into t_331 values (4, default)");
        ResultSet resultSet = statement.executeQuery(" select * from t_331");
        String[] stringArray = new String[]{"A", "B"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"4", "0"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate(" drop table t_331");
        this.rollback();
        statement.close();
    }

    public void testJira3013() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table tabWithUserAndSchemaDefaults(             cUser           CHAR(8) default user,             cCurrent_user   CHAR(8) default current_user,             cSession_user   CHAR(8) default session_user,             cCurrent_schema CHAR(128) default current schema)");
        statement.executeUpdate("insert into tabWithUserAndSchemaDefaults values (default, default, default, default)");
        ResultSet resultSet = statement.executeQuery(" select * from tabWithUserAndSchemaDefaults");
        String[] stringArray = new String[]{"CUSER", "CCURRENT_USER", "CSESSION_USER", "CCURRENT_SCHEMA"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"APP", "APP", "APP", "APP"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        ColumnDefaultsTest.assertStatementError("42894", statement, "create table tabWithUserDefaultTooNarrowColumn(       c1 CHAR(7) default user)");
        ColumnDefaultsTest.assertStatementError("42894", statement, "create table tabWithSchemaDefaultTooNarrowColumn(       c1 CHAR(127) default current sqlid)");
        statement.executeUpdate(" drop table tabWithUserAndSchemaDefaults");
        this.rollback();
        statement.close();
    }

    public void testDerby118_and_5829() throws SQLException {
        Statement statement = this.createStatement();
        String string = Formatters.repeatChar("-", 400);
        statement.executeUpdate("create table tabLongVarchar(    c varchar(400) default '" + string + "')");
        statement.executeUpdate("insert into  tabLongVarchar    values default");
        ResultSet resultSet = statement.executeQuery("select c from tabLongVarchar");
        JDBC.assertSingleValueResultSet(resultSet, string);
        statement.executeUpdate("create table tabLongChar(    c char(254) default '" + string + "')");
        try {
            statement.executeUpdate("insert into tabLongChar values default");
            ColumnDefaultsTest.fail();
        }
        catch (SQLException sQLException) {
            ColumnDefaultsTest.assertSQLState("22001", sQLException);
        }
        statement.executeUpdate("create table tabSmallIntFloat(si smallint default 3.14)");
        statement.executeUpdate("insert into  tabSmallIntFloat values default");
        resultSet = statement.executeQuery("select si from tabSmallIntFloat");
        JDBC.assertSingleValueResultSet(resultSet, "3");
        try {
            statement.executeUpdate("create table tabIntFloat(i int default 3.14)");
            ColumnDefaultsTest.fail();
        }
        catch (SQLException sQLException) {
            ColumnDefaultsTest.assertSQLState("42894", sQLException);
        }
    }
}

