/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import flash.tools.debugger.concrete.DValue;
import flash.tools.debugger.concrete.PlayerSession;
import flash.tools.debugger.concrete.PlayerSessionManager;
import flash.tools.debugger.events.FaultEvent;

public class DVariable
implements Variable,
Comparable {
    private String m_rawName;
    private String m_name;
    private String m_namespace = "";
    private int m_attribs;
    protected Value m_value;
    private boolean m_firedGetter;
    private String m_definingClass;
    private byte m_level;
    private Session m_session;
    long m_nonProtoParentId;
    private int m_isolateId;
    public static final int kNormalObjectType = 0;
    public static final int kXMLSocketObjectType = 1;
    public static final int kTextFieldObjectType = 2;
    public static final int kButtonObjectType = 3;
    public static final int kNumberObjectType = 4;
    public static final int kBooleanObjectType = 5;
    public static final int kNativeStringObject = 6;
    public static final int kNativeArrayObject = 7;
    public static final int kDateObjectType = 8;
    public static final int kSoundObjectType = 9;
    public static final int kNativeXMLDoc = 10;
    public static final int kNativeXMLNode = 11;
    public static final int kNativeCameraObject = 12;
    public static final int kNativeMicrophoneObject = 13;
    public static final int kNativeCommunicationObject = 14;
    public static final int kNetConnectionObjectType = 15;
    public static final int kNetStreamObjectType = 16;
    public static final int kVideoObjectType = 17;
    public static final int kTextFormatObjectType = 18;
    public static final int kSharedObjectType = 19;
    public static final int kSharedObjectDataType = 20;
    public static final int kPrintJobObjectType = 21;
    public static final int kMovieClipLoaderObjectType = 22;
    public static final int kStyleSheetObjectType = 23;
    public static final int kFapPacketDummyObject = 24;
    public static final int kLoadVarsObject = 25;
    public static final int kTextSnapshotType = 26;

    public DVariable(String name, DValue value, int isolateId) {
        int doubleColon;
        this.m_rawName = name;
        this.m_attribs = value.getAttributes();
        if (name != null && !this.isAttributeSet(0) && (doubleColon = name.lastIndexOf("::")) >= 0) {
            this.m_namespace = name.substring(0, doubleColon);
            int at = this.m_namespace.indexOf(64);
            if (at != -1) {
                this.m_namespace = this.m_namespace.substring(0, at);
            }
            name = name.substring(doubleColon + 2);
        }
        this.m_name = name;
        this.m_nonProtoParentId = -1L;
        this.m_value = value;
        value.setSession(this.m_session);
        this.m_isolateId = isolateId;
    }

    public String getName() {
        return this.m_name;
    }

    public int getAttributes() {
        return this.m_attribs;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public int getScope() {
        return this.m_attribs & 0x3800000;
    }

    public int getLevel() {
        return this.m_level;
    }

    public String getDefiningClass() {
        return this.m_definingClass;
    }

    public int getIsolateId() {
        return this.m_isolateId;
    }

    public void makePublic() {
        int attributes = this.getAttributes();
        attributes &= 0xFC7FFFFF;
        this.setAttributes(attributes |= 0);
        this.m_namespace = "";
    }

    public Value getValue() {
        if (this.m_session != null && this.m_session.getPreference("$invokegetters") != 0) {
            try {
                this.invokeGetter(this.m_session);
            }
            catch (NotSuspendedException notSuspendedException) {
            }
            catch (NoResponseException noResponseException) {
            }
            catch (NotConnectedException notConnectedException) {
                // empty catch block
            }
        }
        return this.m_value;
    }

    public boolean hasValueChanged(Session s) {
        Value previousParent;
        boolean hasValueChanged = false;
        if (s instanceof PlayerSession && (previousParent = ((PlayerSession)s).getPreviousValue(this.m_nonProtoParentId, this.m_isolateId)) != null) {
            try {
                String previousValueAsString;
                Value previousValue;
                Variable previousMember = previousParent.getMemberNamed(null, this.getName());
                if (previousMember instanceof DVariable && !previousMember.needsToInvokeGetter() && (previousValue = ((DVariable)previousMember).m_value) != null && (previousValueAsString = previousValue.getValueAsString()) != null && !previousValueAsString.equals(this.getValue().getValueAsString())) {
                    hasValueChanged = true;
                }
            }
            catch (PlayerDebugException playerDebugException) {
                // empty catch block
            }
        }
        return hasValueChanged;
    }

    public FaultEvent setValue(Session s, int type, String value) throws NotSuspendedException, NoResponseException, NotConnectedException {
        return ((PlayerSession)s).setScalarMember(this.m_nonProtoParentId, this.m_rawName, type, value, this.m_isolateId);
    }

    public boolean isAttributeSet(int att) {
        if ((att & 0x3800000) == att) {
            return this.getScope() == att;
        }
        return (this.getAttributes() & att) == att;
    }

    public void clearAttribute(int att) {
        this.m_attribs = (att & 0x3800000) == att ? this.m_attribs & 0xFC7FFFFF | 0 : (this.m_attribs &= ~att);
    }

    public void setAttribute(int att) {
        this.m_attribs = (att & 0x3800000) == att ? this.m_attribs & 0xFC7FFFFF | att : (this.m_attribs |= att);
    }

    public String getRawName() {
        return this.m_rawName;
    }

    public String getQualifiedName() {
        if (this.m_namespace.length() > 0) {
            return this.m_namespace + "::" + this.m_name;
        }
        return this.m_name;
    }

    public int compareTo(Object o2) {
        Variable v2 = (Variable)o2;
        String n1 = this.getName();
        String n2 = v2.getName();
        return String.CASE_INSENSITIVE_ORDER.compare(n1, n2);
    }

    public boolean needsToInvokeGetter() {
        return this.isAttributeSet(524288) && this.m_value.getId() != -1L && !this.m_firedGetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeGetter(Session s) throws NotSuspendedException, NoResponseException, NotConnectedException {
        PlayerSession playerSession;
        if (this.needsToInvokeGetter() && (playerSession = (PlayerSession)s).getRawValue(this.m_value.getId(), this.m_isolateId) == this.m_value) {
            int oldInvokeGetters = playerSession.getPreference("$invokegetters");
            playerSession.setPreference("$invokegetters", 1);
            try {
                Value v = playerSession.getValue(this.m_nonProtoParentId, this.getRawName(), this.m_isolateId);
                if (v != null) {
                    this.m_value = v;
                    this.m_firedGetter = true;
                    if (this.m_value instanceof DValue) {
                        ((DValue)this.m_value).setSession(s);
                    }
                }
            }
            finally {
                playerSession.setPreference("$invokegetters", oldInvokeGetters);
            }
        }
    }

    public void setName(String s) {
        this.m_name = s;
    }

    public void setAttributes(int f) {
        this.m_attribs = f;
        ((DValue)this.getValue()).setAttributes(f);
    }

    public void setSession(Session s) {
        this.m_session = s;
        if (this.m_value instanceof DValue) {
            ((DValue)this.m_value).setSession(s);
        }
    }

    public void setDefiningClass(int level, String definingClass) {
        this.m_level = (byte)Math.min(level, 255);
        this.m_definingClass = definingClass;
    }

    public String toString() {
        return this.getValue().getValueAsString();
    }

    public static String typeNameFor(int type) {
        String s = "string";
        switch (type) {
            case 0: {
                s = "number";
                break;
            }
            case 1: {
                s = "boolean";
                break;
            }
            case 2: {
                s = "string";
                break;
            }
            case 3: {
                s = "object";
                break;
            }
            case 4: {
                s = "function";
                break;
            }
            case 5: {
                s = "movieclip";
                break;
            }
            case 6: {
                s = "null";
                break;
            }
            default: {
                s = "undefined";
            }
        }
        return s;
    }

    public static String classNameFor(long clsType, boolean isMc) {
        String clsName;
        switch ((int)clsType) {
            case 0: {
                clsName = isMc ? "MovieClip" : "Object";
                break;
            }
            case 1: {
                clsName = "XMLSocket";
                break;
            }
            case 2: {
                clsName = "TextField";
                break;
            }
            case 3: {
                clsName = "Button";
                break;
            }
            case 4: {
                clsName = "Number";
                break;
            }
            case 5: {
                clsName = "Boolean";
                break;
            }
            case 6: {
                clsName = "String";
                break;
            }
            case 7: {
                clsName = "Array";
                break;
            }
            case 8: {
                clsName = "Date";
                break;
            }
            case 9: {
                clsName = "Sound";
                break;
            }
            case 10: {
                clsName = "XML";
                break;
            }
            case 11: {
                clsName = "XMLNode";
                break;
            }
            case 12: {
                clsName = "Camera";
                break;
            }
            case 13: {
                clsName = "Microphone";
                break;
            }
            case 14: {
                clsName = "Communication";
                break;
            }
            case 15: {
                clsName = "Connection";
                break;
            }
            case 16: {
                clsName = "Stream";
                break;
            }
            case 17: {
                clsName = "Video";
                break;
            }
            case 18: {
                clsName = "TextFormat";
                break;
            }
            case 19: {
                clsName = "SharedObject";
                break;
            }
            case 20: {
                clsName = "SharedObjectData";
                break;
            }
            case 21: {
                clsName = "PrintJob";
                break;
            }
            case 22: {
                clsName = "MovieClipLoader";
                break;
            }
            case 23: {
                clsName = "StyleSheet";
                break;
            }
            case 24: {
                clsName = "FapPacket";
                break;
            }
            case 25: {
                clsName = "LoadVars";
                break;
            }
            case 26: {
                clsName = "TextSnapshot";
                break;
            }
            default: {
                clsName = PlayerSessionManager.getLocalizationManager().getLocalizedTextString("unknown") + "<" + clsType + ">";
            }
        }
        return clsName;
    }
}

