/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools.oem.internal;

import flex2.compiler.ILocalizableMessage;
import flex2.compiler.util.AbstractLogger;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.oem.Logger;
import flex2.tools.oem.internal.GenericMessage;

public class OEMLogAdapter
extends AbstractLogger {
    private Logger oemLogger;
    private int errorCount;
    private int warningCount;

    public OEMLogAdapter(Logger l) {
        this.init(ThreadLocalToolkit.getLocalizationManager());
        this.setLogger(l);
    }

    public void setLogger(Logger l) {
        this.oemLogger = l;
    }

    public int errorCount() {
        return this.errorCount;
    }

    public void includedFileAffected(String path) {
        this.logInfo(path, -1, -1, "");
    }

    public void includedFileUpdated(String path) {
        this.logInfo(path, -1, -1, "");
    }

    public void log(ILocalizableMessage m) {
        this.log(m, null);
    }

    public void log(ILocalizableMessage m, String source) {
        if ("warning".equals(m.getLevel())) {
            ++this.warningCount;
        } else if ("error".equals(m.getLevel())) {
            ++this.errorCount;
        }
        if (this.oemLogger != null) {
            this.oemLogger.log(m, -1, null);
        }
    }

    public void logDebug(String debug) {
    }

    public void logDebug(String path, String debug) {
    }

    public void logDebug(String path, int line, String debug) {
    }

    public void logDebug(String path, int line, int col, String debug) {
    }

    public void logError(String error) {
        this.logError(null, -1, -1, error, null, -1);
    }

    public void logError(String path, String error) {
        this.logError(null, -1, -1, error, null, -1);
    }

    public void logError(String path, String error, int errorCode) {
        this.logError(path, -1, -1, error, null, errorCode);
    }

    public void logError(String path, int line, String error) {
        this.logError(path, line, -1, error, null, -1);
    }

    public void logError(String path, int line, String error, int errorCode) {
        this.logError(path, line, -1, error, null, errorCode);
    }

    public void logError(String path, int line, int col, String error) {
        this.logError(path, line, col, error, null, -1);
    }

    public void logError(String path, int line, int col, String error, String source) {
        this.logError(path, line, col, error, source, -1);
    }

    public void logError(String path, int line, int col, String error, String source, int errorCode) {
        ++this.errorCount;
        if (this.oemLogger != null) {
            this.oemLogger.log(new GenericMessage("error", path, line, col, error), errorCode, source);
        }
    }

    public void logInfo(String info) {
        this.logInfo(null, -1, -1, info);
    }

    public void logInfo(String path, String info) {
        this.logInfo(path, -1, -1, info);
    }

    public void logInfo(String path, int line, String info) {
        this.logInfo(path, line, -1, info);
    }

    public void logInfo(String path, int line, int col, String info) {
        if (this.oemLogger != null) {
            this.oemLogger.log(new GenericMessage("info", path, line, col, info), -1, null);
        }
    }

    public void logWarning(String warning) {
        this.logWarning(null, -1, -1, warning, null, -1);
    }

    public void logWarning(String path, String warning) {
        this.logWarning(path, -1, -1, warning, null, -1);
    }

    public void logWarning(String path, String warning, int errorCode) {
        this.logWarning(path, -1, -1, warning, null, errorCode);
    }

    public void logWarning(String path, int line, String warning) {
        this.logWarning(path, line, -1, warning, null, -1);
    }

    public void logWarning(String path, int line, String warning, int errorCode) {
        this.logWarning(path, line, -1, warning, null, errorCode);
    }

    public void logWarning(String path, int line, int col, String warning) {
        this.logWarning(path, line, col, warning, null, -1);
    }

    public void logWarning(String path, int line, int col, String warning, String source) {
        this.logWarning(path, line, col, warning, source, -1);
    }

    public void logWarning(String path, int line, int col, String warning, String source, int errorCode) {
        ++this.warningCount;
        if (this.oemLogger != null) {
            this.oemLogger.log(new GenericMessage("warning", path, line, col, warning), errorCode, source);
        }
    }

    public void needsCompilation(String path, String reason) {
        this.logInfo(path, -1, -1, reason);
    }

    public int warningCount() {
        return this.warningCount;
    }
}

