/*
 * Decompiled with CFR 0.152.
 */
package flash.tools.debugger.concrete;

import flash.tools.debugger.Frame;
import flash.tools.debugger.Location;
import flash.tools.debugger.NoResponseException;
import flash.tools.debugger.NotConnectedException;
import flash.tools.debugger.NotSuspendedException;
import flash.tools.debugger.Session;
import flash.tools.debugger.Variable;
import flash.tools.debugger.concrete.DLocation;
import flash.tools.debugger.concrete.DModule;
import flash.tools.debugger.concrete.DVariable;
import flash.tools.debugger.concrete.PlayerSession;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DStackContext
implements Frame {
    private DModule m_source;
    private String m_functionSignature;
    private int m_depth;
    private int m_module;
    private int m_line;
    private DVariable m_this;
    private Map<String, DVariable> m_args;
    private Map<String, DVariable> m_locals;
    private List<DVariable> m_scopeChain;
    private DLocation m_location;
    private int m_swfIndex;
    private int m_offset;
    private boolean m_populated;
    private DVariable m_activationObject;
    private int m_isolateId;

    public DStackContext(int module, int line, DModule f, long thisId, String functionSignature, int depth, int isolateId) {
        this.m_source = f;
        this.m_module = module;
        this.m_line = line;
        this.m_this = null;
        this.m_functionSignature = functionSignature;
        this.m_depth = depth;
        this.m_args = new LinkedHashMap<String, DVariable>();
        this.m_locals = new LinkedHashMap<String, DVariable>();
        this.m_scopeChain = new ArrayList<DVariable>();
        this.m_populated = false;
        this.m_isolateId = isolateId;
        this.m_location = new DLocation(this.m_source, line, isolateId);
    }

    public Location getLocation() {
        return this.m_location;
    }

    public Variable[] getArguments(Session s) throws NoResponseException, NotSuspendedException, NotConnectedException {
        this.populate(s);
        return this.m_args.values().toArray(new Variable[this.m_args.size()]);
    }

    public Variable[] getLocals(Session s) throws NoResponseException, NotSuspendedException, NotConnectedException {
        this.populate(s);
        return this.m_locals.values().toArray(new Variable[this.m_locals.size()]);
    }

    public Variable getThis(Session s) throws NoResponseException, NotSuspendedException, NotConnectedException {
        this.populate(s);
        return this.getThis();
    }

    public Variable[] getScopeChain(Session s) throws NoResponseException, NotSuspendedException, NotConnectedException {
        this.populate(s);
        return this.m_scopeChain.toArray(new Variable[this.m_scopeChain.size()]);
    }

    public String getCallSignature() {
        return this.m_functionSignature;
    }

    public int getModule() {
        return this.m_module;
    }

    public int getLine() {
        return this.m_line;
    }

    public DVariable getThis() {
        return this.m_this;
    }

    void addArgument(DVariable v) {
        this.m_args.put(v.getName(), v);
    }

    void addLocal(DVariable v) {
        this.m_locals.put(v.getName(), v);
    }

    void addScopeChainEntry(DVariable v) {
        this.m_scopeChain.add(v);
    }

    void removeAllArguments() {
        this.m_args.clear();
    }

    void removeAllLocals() {
        this.m_locals.clear();
        this.m_activationObject = null;
    }

    void removeAllScopeChainEntries() {
        this.m_scopeChain.clear();
    }

    void removeAllVariables() {
        this.removeAllLocals();
        this.removeAllArguments();
        this.removeAllScopeChainEntries();
    }

    void setDepth(int depth) {
        this.m_depth = depth;
    }

    void setThis(DVariable v) {
        this.m_this = v;
    }

    void setSwfIndex(int index) {
        this.m_swfIndex = index;
    }

    void setOffset(int offset) {
        this.m_offset = offset;
    }

    void setIsolateId(int id) {
        this.m_isolateId = id;
    }

    void markStale() {
        this.m_populated = false;
    }

    void convertLocalToActivationObject(DVariable v) {
        this.m_activationObject = v;
        this.m_locals.remove(v.getName());
    }

    DVariable getActivationObject() {
        return this.m_activationObject;
    }

    void populate(Session s) throws NoResponseException, NotSuspendedException, NotConnectedException {
        if (!this.m_populated) {
            PlayerSession ses = (PlayerSession)s;
            ses.requestFrame(this.m_depth, this.m_isolateId);
            this.m_populated = true;
        }
    }

    public int getIsolateId() {
        return this.m_isolateId;
    }
}

