/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.forks.velocity.runtime.directive;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import org.apache.flex.forks.velocity.context.InternalContextAdapter;
import org.apache.flex.forks.velocity.context.VMContext;
import org.apache.flex.forks.velocity.exception.MethodInvocationException;
import org.apache.flex.forks.velocity.runtime.RuntimeServices;
import org.apache.flex.forks.velocity.runtime.directive.Directive;
import org.apache.flex.forks.velocity.runtime.directive.VMProxyArg;
import org.apache.flex.forks.velocity.runtime.parser.Token;
import org.apache.flex.forks.velocity.runtime.parser.node.Node;
import org.apache.flex.forks.velocity.runtime.visitor.VMReferenceMungeVisitor;
import org.apache.flex.forks.velocity.util.StringUtils;

public class VelocimacroProxy
extends Directive {
    private String macroName = "";
    private String[] argumentNamesArray = null;
    private VMProxyArg[] args;
    private Node nodeTree = null;
    private String namespace = "";
    private boolean init = false;

    public String getName() {
        return this.macroName;
    }

    public int getType() {
        return 2;
    }

    public void setName(String name) {
        this.macroName = name;
    }

    public void setArgArray(String[] arr) {
        this.argumentNamesArray = arr;
        this.args = new VMProxyArg[arr.length];
    }

    public void setNodeTree(Node tree) {
        this.nodeTree = tree;
    }

    public void setNamespace(String ns) {
        this.namespace = ns;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, MethodInvocationException {
        try {
            if (this.nodeTree != null) {
                VMContext vmc = new VMContext(context, this.rsvc);
                for (int i = 0; i < this.argumentNamesArray.length; ++i) {
                    vmc.addVMProxyArg(this.args[i]);
                }
                this.nodeTree.render(vmc, writer);
            } else {
                this.rsvc.error("VM error : " + this.macroName + ". Null AST");
            }
        }
        catch (Exception e) {
            if (e instanceof MethodInvocationException) {
                throw (MethodInvocationException)e;
            }
            this.rsvc.error("VelocimacroProxy.render() : exception VM = #" + this.macroName + "() : " + StringUtils.stackTrace(e));
        }
        return true;
    }

    public void init(RuntimeServices rs, InternalContextAdapter context, Node node) throws Exception {
        super.init(rs, context, node);
        int i = node.jjtGetNumChildren();
        if (this.argumentNamesArray.length != i) {
            this.rsvc.error("VM #" + this.macroName + ": error : too " + (this.argumentNamesArray.length > i ? "few" : "many") + " arguments to macro. Wanted " + this.argumentNamesArray.length + " got " + i);
            return;
        }
        for (i = 0; i < this.argumentNamesArray.length; ++i) {
            this.args[i] = new VMProxyArg(this.rsvc, this.argumentNamesArray[i], node.jjtGetChild(i));
        }
    }

    public boolean setupMacro(String[] callArgs, int[] callArgTypes) {
        this.setupProxyArgs(callArgs, callArgTypes);
        return true;
    }

    private void setupTree(String[] callArgs) {
        try {
            HashMap<String, String> hm = new HashMap<String, String>();
            for (int i = 0; i < this.argumentNamesArray.length; ++i) {
                String arg = callArgs[i];
                if (arg.charAt(0) != '$') continue;
                hm.put(this.argumentNamesArray[i], arg);
            }
            VMReferenceMungeVisitor v = new VMReferenceMungeVisitor(hm);
            this.nodeTree.jjtAccept(v, null);
        }
        catch (Exception e) {
            this.rsvc.error("VelocimacroManager.parseTree() : exception " + this.macroName + " : " + StringUtils.stackTrace(e));
        }
    }

    private void setupProxyArgs(String[] callArgs, int[] callArgTypes) {
    }

    private String[] getArgArray(Node node) {
        int numArgs = node.jjtGetNumChildren();
        String[] args = new String[numArgs];
        int i = 0;
        Token t = null;
        Token tLast = null;
        while (i < numArgs) {
            args[i] = "";
            t = node.jjtGetChild(i).getFirstToken();
            tLast = node.jjtGetChild(i).getLastToken();
            while (t != tLast) {
                int n = i;
                args[n] = args[n] + t.image;
                t = t.next;
            }
            int n = i++;
            args[n] = args[n] + t.image;
        }
        return args;
    }
}

