/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom;

import com.adobe.fxg.FXGVersion;
import com.adobe.internal.fxg.dom.DOMParserHelper;
import com.adobe.internal.fxg.dom.GraphicContentNode;
import com.adobe.internal.fxg.dom.types.FillMode;

public class BitmapGraphicNode
extends GraphicContentNode {
    public double width = Double.NaN;
    public double height = Double.NaN;
    public String source;
    public boolean repeat = true;
    public FillMode fillMode = FillMode.SCALE;

    public String getNodeName() {
        if (this.getFileVersion().equals(FXGVersion.v1_0)) {
            return "BitmapGraphic";
        }
        return "BitmapImage";
    }

    public void setAttribute(String name, String value) {
        if ("width".equals(name)) {
            this.width = DOMParserHelper.parseDouble(this, value, name);
        } else if ("height".equals(name)) {
            this.height = DOMParserHelper.parseDouble(this, value, name);
        } else if ("source".equals(name)) {
            this.source = value;
        } else if (this.getFileVersion().equalTo(FXGVersion.v1_0) && "repeat".equals(name)) {
            this.repeat = DOMParserHelper.parseBoolean(this, value, name);
        } else if (!this.getFileVersion().equalTo(FXGVersion.v1_0) && "fillMode".equals(name)) {
            this.fillMode = DOMParserHelper.parseFillMode(this, value, name, this.fillMode);
        } else {
            super.setAttribute(name, value);
        }
    }
}

