/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.CharConversionException;
import java.io.EOFException;
import java.io.IOException;
import org.apache.xerces.impl.XMLDocumentFragmentScannerMMImpl;
import org.apache.xerces.impl.XMLEntityHandler;
import org.apache.xerces.impl.dtd.XMLDTDDescription;
import org.apache.xerces.impl.io.MalformedByteSequenceException;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDTDScanner;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLDocumentScannerMMImpl
extends XMLDocumentFragmentScannerMMImpl {
    protected static final int SCANNER_STATE_XML_DECL = 0;
    protected static final int SCANNER_STATE_PROLOG = 5;
    protected static final int SCANNER_STATE_TRAILING_MISC = 12;
    protected static final int SCANNER_STATE_DTD_INTERNAL_DECLS = 17;
    protected static final int SCANNER_STATE_DTD_EXTERNAL = 18;
    protected static final int SCANNER_STATE_DTD_EXTERNAL_DECLS = 19;
    protected static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected static final String DISALLOW_DOCTYPE_DECL_FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
    protected static final String DTD_SCANNER = "http://apache.org/xml/properties/internal/dtd-scanner";
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    protected static final String NAMESPACE_CONTEXT = "http://apache.org/xml/properties/internal/namespace-context";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://apache.org/xml/features/nonvalidating/load-external-dtd", "http://apache.org/xml/features/disallow-doctype-decl"};
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[]{Boolean.TRUE, Boolean.FALSE};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/dtd-scanner", "http://apache.org/xml/properties/internal/validation-manager", "http://apache.org/xml/properties/internal/namespace-context"};
    private static final Object[] PROPERTY_DEFAULTS = new Object[]{null, null, null};
    protected XMLDTDScanner fDTDScanner;
    protected ValidationManager fValidationManager;
    protected boolean fScanningDTD;
    protected String fDoctypeName;
    protected String fDoctypePublicId;
    protected String fDoctypeSystemId;
    protected NamespaceContext fNamespaceContext = new NamespaceSupport();
    protected boolean fLoadExternalDTD = true;
    protected boolean fDisallowDoctype = false;
    protected boolean fSeenDoctypeDecl;
    protected final XMLDocumentFragmentScannerMMImpl.Dispatcher fXMLDeclDispatcher = new XMLDeclDispatcher();
    protected final XMLDocumentFragmentScannerMMImpl.Dispatcher fPrologDispatcher = new PrologDispatcher();
    protected final XMLDocumentFragmentScannerMMImpl.Dispatcher fDTDDispatcher = new DTDDispatcher();
    protected final XMLDocumentFragmentScannerMMImpl.Dispatcher fTrailingMiscDispatcher = new TrailingMiscDispatcher();
    private final String[] fStrings = new String[3];
    private final XMLString fString = new XMLString();
    private final XMLStringBuffer fStringBuffer = new XMLStringBuffer();
    private XMLInputSource fExternalSubsetSource = null;
    private final XMLDTDDescription fDTDDescription = new XMLDTDDescription(null, null, null, null, null);

    public void setInputSource(XMLInputSource inputSource) throws IOException {
        this.fEntityManager.setEntityHandler((XMLEntityHandler)this);
        this.fEntityManager.startDocumentEntity(inputSource);
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        super.reset(componentManager);
        this.fDoctypeName = null;
        this.fDoctypePublicId = null;
        this.fDoctypeSystemId = null;
        this.fSeenDoctypeDecl = false;
        this.fScanningDTD = false;
        this.fExternalSubsetSource = null;
        if (!this.fParserSettings) {
            this.fNamespaceContext.reset();
            this.setScannerState(0);
            this.setDispatcher(this.fXMLDeclDispatcher);
            return;
        }
        try {
            this.fLoadExternalDTD = componentManager.getFeature(LOAD_EXTERNAL_DTD);
        }
        catch (XMLConfigurationException e) {
            this.fLoadExternalDTD = true;
        }
        try {
            this.fDisallowDoctype = componentManager.getFeature(DISALLOW_DOCTYPE_DECL_FEATURE);
        }
        catch (XMLConfigurationException e) {
            this.fDisallowDoctype = false;
        }
        this.fDTDScanner = (XMLDTDScanner)componentManager.getProperty(DTD_SCANNER);
        try {
            this.fValidationManager = (ValidationManager)componentManager.getProperty(VALIDATION_MANAGER);
        }
        catch (XMLConfigurationException e) {
            this.fValidationManager = null;
        }
        try {
            this.fNamespaceContext = (NamespaceContext)componentManager.getProperty(NAMESPACE_CONTEXT);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        if (this.fNamespaceContext == null) {
            this.fNamespaceContext = new NamespaceSupport();
        }
        this.fNamespaceContext.reset();
        this.setScannerState(0);
        this.setDispatcher(this.fXMLDeclDispatcher);
    }

    public String[] getRecognizedFeatures() {
        String[] featureIds = super.getRecognizedFeatures();
        int length = featureIds != null ? featureIds.length : 0;
        String[] combinedFeatureIds = new String[length + RECOGNIZED_FEATURES.length];
        if (featureIds != null) {
            System.arraycopy(featureIds, 0, combinedFeatureIds, 0, featureIds.length);
        }
        System.arraycopy(RECOGNIZED_FEATURES, 0, combinedFeatureIds, length, RECOGNIZED_FEATURES.length);
        return combinedFeatureIds;
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        super.setFeature(featureId, state);
        if (featureId.startsWith("http://apache.org/xml/features/")) {
            int suffixLength = featureId.length() - "http://apache.org/xml/features/".length();
            if (suffixLength == "nonvalidating/load-external-dtd".length() && featureId.endsWith("nonvalidating/load-external-dtd")) {
                this.fLoadExternalDTD = state;
                return;
            }
            if (suffixLength == "disallow-doctype-decl".length() && featureId.endsWith("disallow-doctype-decl")) {
                this.fDisallowDoctype = state;
                return;
            }
        }
    }

    public String[] getRecognizedProperties() {
        String[] propertyIds = super.getRecognizedProperties();
        int length = propertyIds != null ? propertyIds.length : 0;
        String[] combinedPropertyIds = new String[length + RECOGNIZED_PROPERTIES.length];
        if (propertyIds != null) {
            System.arraycopy(propertyIds, 0, combinedPropertyIds, 0, propertyIds.length);
        }
        System.arraycopy(RECOGNIZED_PROPERTIES, 0, combinedPropertyIds, length, RECOGNIZED_PROPERTIES.length);
        return combinedPropertyIds;
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        super.setProperty(propertyId, value);
        if (propertyId.startsWith("http://apache.org/xml/properties/")) {
            int suffixLength = propertyId.length() - "http://apache.org/xml/properties/".length();
            if (suffixLength == "internal/dtd-scanner".length() && propertyId.endsWith("internal/dtd-scanner")) {
                this.fDTDScanner = (XMLDTDScanner)value;
            }
            if (suffixLength == "internal/namespace-context".length() && propertyId.endsWith("internal/namespace-context") && value != null) {
                this.fNamespaceContext = (NamespaceContext)value;
            }
            return;
        }
    }

    public Boolean getFeatureDefault(String featureId) {
        for (int i = 0; i < RECOGNIZED_FEATURES.length; ++i) {
            if (!RECOGNIZED_FEATURES[i].equals(featureId)) continue;
            return FEATURE_DEFAULTS[i];
        }
        return super.getFeatureDefault(featureId);
    }

    public Object getPropertyDefault(String propertyId) {
        for (int i = 0; i < RECOGNIZED_PROPERTIES.length; ++i) {
            if (!RECOGNIZED_PROPERTIES[i].equals(propertyId)) continue;
            return PROPERTY_DEFAULTS[i];
        }
        return super.getPropertyDefault(propertyId);
    }

    public void startEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
        super.startEntity(name, identifier, encoding, augs);
        if (!name.equals("[xml]") && this.fEntityScanner.isExternal()) {
            this.setScannerState(16);
        }
        if (this.fDocumentHandler != null && name.equals("[xml]")) {
            this.fDocumentHandler.startDocument((XMLLocator)this.fEntityScanner, encoding, this.fNamespaceContext, null);
        }
    }

    public void endEntity(String name, Augmentations augs) throws XNIException {
        super.endEntity(name, augs);
        if (this.fDocumentHandler != null && name.equals("[xml]")) {
            this.fDocumentHandler.endDocument(null);
        }
    }

    protected XMLDocumentFragmentScannerMMImpl.Dispatcher createContentDispatcher() {
        return new ContentDispatcher();
    }

    protected boolean scanDoctypeDecl() throws IOException, XNIException {
        if (!this.fEntityScanner.skipSpaces()) {
            this.reportFatalError("MSG_SPACE_REQUIRED_BEFORE_ROOT_ELEMENT_TYPE_IN_DOCTYPEDECL", null);
        }
        this.fDoctypeName = this.fEntityScanner.scanName();
        if (this.fDoctypeName == null) {
            this.reportFatalError("MSG_ROOT_ELEMENT_TYPE_REQUIRED", null);
        }
        if (this.fEntityScanner.skipSpaces()) {
            this.scanExternalID(this.fStrings, false);
            this.fDoctypeSystemId = this.fStrings[0];
            this.fDoctypePublicId = this.fStrings[1];
            this.fEntityScanner.skipSpaces();
        }
        boolean bl = this.fHasExternalDTD = this.fDoctypeSystemId != null;
        if (!this.fHasExternalDTD && this.fExternalSubsetResolver != null) {
            this.fDTDDescription.setValues(null, null, this.fEntityManager.getCurrentResourceIdentifier().getExpandedSystemId(), null);
            this.fDTDDescription.setRootName(this.fDoctypeName);
            this.fExternalSubsetSource = this.fExternalSubsetResolver.getExternalSubset((org.apache.xerces.xni.grammars.XMLDTDDescription)this.fDTDDescription);
            boolean bl2 = this.fHasExternalDTD = this.fExternalSubsetSource != null;
        }
        if (this.fDocumentHandler != null) {
            if (this.fExternalSubsetSource == null) {
                this.fDocumentHandler.doctypeDecl(this.fDoctypeName, this.fDoctypePublicId, this.fDoctypeSystemId, null);
            } else {
                this.fDocumentHandler.doctypeDecl(this.fDoctypeName, this.fExternalSubsetSource.getPublicId(), this.fExternalSubsetSource.getSystemId(), null);
            }
        }
        boolean internalSubset = true;
        if (!this.fEntityScanner.skipChar(91)) {
            internalSubset = false;
            this.fEntityScanner.skipSpaces();
            if (!this.fEntityScanner.skipChar(62)) {
                this.reportFatalError("DoctypedeclUnterminated", new Object[]{this.fDoctypeName});
            }
            --this.fMarkupDepth;
        }
        return internalSubset;
    }

    protected String getScannerStateName(int state) {
        switch (state) {
            case 0: {
                return "SCANNER_STATE_XML_DECL";
            }
            case 5: {
                return "SCANNER_STATE_PROLOG";
            }
            case 12: {
                return "SCANNER_STATE_TRAILING_MISC";
            }
            case 17: {
                return "SCANNER_STATE_DTD_INTERNAL_DECLS";
            }
            case 18: {
                return "SCANNER_STATE_DTD_EXTERNAL";
            }
            case 19: {
                return "SCANNER_STATE_DTD_EXTERNAL_DECLS";
            }
        }
        return super.getScannerStateName(state);
    }

    protected final class TrailingMiscDispatcher
    implements XMLDocumentFragmentScannerMMImpl.Dispatcher {
        protected TrailingMiscDispatcher() {
        }

        public boolean dispatch(boolean complete) throws IOException, XNIException {
            try {
                boolean again;
                do {
                    again = false;
                    switch (XMLDocumentScannerMMImpl.this.fScannerState) {
                        case 12: {
                            XMLDocumentScannerMMImpl.this.fEntityScanner.skipSpaces();
                            if (XMLDocumentScannerMMImpl.this.fEntityScanner.skipChar(60)) {
                                XMLDocumentScannerMMImpl.this.setScannerState(1);
                                again = true;
                                break;
                            }
                            XMLDocumentScannerMMImpl.this.setScannerState(7);
                            again = true;
                            break;
                        }
                        case 1: {
                            ++XMLDocumentScannerMMImpl.this.fMarkupDepth;
                            if (XMLDocumentScannerMMImpl.this.fEntityScanner.skipChar(63)) {
                                XMLDocumentScannerMMImpl.this.setScannerState(3);
                                again = true;
                                break;
                            }
                            if (XMLDocumentScannerMMImpl.this.fEntityScanner.skipChar(33)) {
                                XMLDocumentScannerMMImpl.this.setScannerState(2);
                                again = true;
                                break;
                            }
                            if (XMLDocumentScannerMMImpl.this.fEntityScanner.skipChar(47)) {
                                XMLDocumentScannerMMImpl.this.reportFatalError("MarkupNotRecognizedInMisc", null);
                                again = true;
                                break;
                            }
                            if (XMLDocumentScannerMMImpl.this.isValidNameStartChar(XMLDocumentScannerMMImpl.this.fEntityScanner.peekChar())) {
                                XMLDocumentScannerMMImpl.this.reportFatalError("MarkupNotRecognizedInMisc", null);
                                XMLDocumentScannerMMImpl.this.scanStartElement();
                                XMLDocumentScannerMMImpl.this.setScannerState(7);
                                break;
                            }
                            if (XMLDocumentScannerMMImpl.this.isValidNameStartHighSurrogate(XMLDocumentScannerMMImpl.this.fEntityScanner.peekChar())) {
                                XMLDocumentScannerMMImpl.this.reportFatalError("MarkupNotRecognizedInMisc", null);
                                XMLDocumentScannerMMImpl.this.scanStartElement();
                                XMLDocumentScannerMMImpl.this.setScannerState(7);
                                break;
                            }
                            XMLDocumentScannerMMImpl.this.reportFatalError("MarkupNotRecognizedInMisc", null);
                            break;
                        }
                        case 3: {
                            XMLDocumentScannerMMImpl.this.scanPI();
                            XMLDocumentScannerMMImpl.this.setScannerState(12);
                            break;
                        }
                        case 2: {
                            if (!XMLDocumentScannerMMImpl.this.fEntityScanner.skipString("--")) {
                                XMLDocumentScannerMMImpl.this.reportFatalError("InvalidCommentStart", null);
                            }
                            XMLDocumentScannerMMImpl.this.scanComment();
                            XMLDocumentScannerMMImpl.this.setScannerState(12);
                            break;
                        }
                        case 7: {
                            int ch = XMLDocumentScannerMMImpl.this.fEntityScanner.peekChar();
                            if (ch == -1) {
                                XMLDocumentScannerMMImpl.this.setScannerState(14);
                                return false;
                            }
                            XMLDocumentScannerMMImpl.this.reportFatalError("ContentIllegalInTrailingMisc", null);
                            XMLDocumentScannerMMImpl.this.fEntityScanner.scanChar();
                            XMLDocumentScannerMMImpl.this.setScannerState(12);
                            break;
                        }
                        case 8: {
                            XMLDocumentScannerMMImpl.this.reportFatalError("ReferenceIllegalInTrailingMisc", null);
                            XMLDocumentScannerMMImpl.this.setScannerState(12);
                            break;
                        }
                        case 14: {
                            return false;
                        }
                    }
                } while (complete || again);
            }
            catch (MalformedByteSequenceException e) {
                XMLDocumentScannerMMImpl.this.fErrorReporter.reportError(e.getDomain(), e.getKey(), e.getArguments(), (short)2, (Exception)((Object)e));
                return false;
            }
            catch (CharConversionException e) {
                XMLDocumentScannerMMImpl.this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "CharConversionFailure", null, (short)2, (Exception)e);
                return false;
            }
            catch (EOFException e) {
                if (XMLDocumentScannerMMImpl.this.fMarkupDepth != 0) {
                    XMLDocumentScannerMMImpl.this.reportFatalError("PrematureEOF", null);
                    return false;
                }
                XMLDocumentScannerMMImpl.this.setScannerState(14);
                return false;
            }
            return true;
        }
    }

    protected class ContentDispatcher
    extends XMLDocumentFragmentScannerMMImpl.FragmentContentDispatcher {
        protected ContentDispatcher() {
        }

        protected boolean scanForDoctypeHook() throws IOException, XNIException {
            if (XMLDocumentScannerMMImpl.this.fEntityScanner.skipString("DOCTYPE")) {
                XMLDocumentScannerMMImpl.this.setScannerState(4);
                return true;
            }
            return false;
        }

        protected boolean elementDepthIsZeroHook() throws IOException, XNIException {
            XMLDocumentScannerMMImpl.this.setScannerState(12);
            XMLDocumentScannerMMImpl.this.setDispatcher(XMLDocumentScannerMMImpl.this.fTrailingMiscDispatcher);
            return true;
        }

        protected boolean scanRootElementHook() throws IOException, XNIException {
            if (XMLDocumentScannerMMImpl.this.fExternalSubsetResolver != null && !XMLDocumentScannerMMImpl.this.fSeenDoctypeDecl && !XMLDocumentScannerMMImpl.this.fDisallowDoctype && (XMLDocumentScannerMMImpl.this.fValidation || XMLDocumentScannerMMImpl.this.fLoadExternalDTD)) {
                XMLDocumentScannerMMImpl.this.scanStartElementName();
                this.resolveExternalSubsetAndRead();
                if (XMLDocumentScannerMMImpl.this.scanStartElementAfterName()) {
                    XMLDocumentScannerMMImpl.this.setScannerState(12);
                    XMLDocumentScannerMMImpl.this.setDispatcher(XMLDocumentScannerMMImpl.this.fTrailingMiscDispatcher);
                    return true;
                }
            } else if (XMLDocumentScannerMMImpl.this.scanStartElement()) {
                XMLDocumentScannerMMImpl.this.setScannerState(12);
                XMLDocumentScannerMMImpl.this.setDispatcher(XMLDocumentScannerMMImpl.this.fTrailingMiscDispatcher);
                return true;
            }
            return false;
        }

        protected void endOfFileHook(EOFException e) throws IOException, XNIException {
            XMLDocumentScannerMMImpl.this.reportFatalError("PrematureEOF", null);
        }

        protected void resolveExternalSubsetAndRead() throws IOException, XNIException {
            XMLDocumentScannerMMImpl.this.fDTDDescription.setValues(null, null, XMLDocumentScannerMMImpl.this.fEntityManager.getCurrentResourceIdentifier().getExpandedSystemId(), null);
            XMLDocumentScannerMMImpl.this.fDTDDescription.setRootName(XMLDocumentScannerMMImpl.this.fElementQName.rawname);
            XMLInputSource src = XMLDocumentScannerMMImpl.this.fExternalSubsetResolver.getExternalSubset((org.apache.xerces.xni.grammars.XMLDTDDescription)XMLDocumentScannerMMImpl.this.fDTDDescription);
            if (src != null) {
                XMLDocumentScannerMMImpl.this.fDoctypeName = XMLDocumentScannerMMImpl.this.fElementQName.rawname;
                XMLDocumentScannerMMImpl.this.fDoctypePublicId = src.getPublicId();
                XMLDocumentScannerMMImpl.this.fDoctypeSystemId = src.getSystemId();
                if (XMLDocumentScannerMMImpl.this.fDocumentHandler != null) {
                    XMLDocumentScannerMMImpl.this.fDocumentHandler.doctypeDecl(XMLDocumentScannerMMImpl.this.fDoctypeName, XMLDocumentScannerMMImpl.this.fDoctypePublicId, XMLDocumentScannerMMImpl.this.fDoctypeSystemId, null);
                }
                try {
                    if (XMLDocumentScannerMMImpl.this.fValidationManager == null || !XMLDocumentScannerMMImpl.this.fValidationManager.isCachedDTD()) {
                        XMLDocumentScannerMMImpl.this.fDTDScanner.setInputSource(src);
                        while (XMLDocumentScannerMMImpl.this.fDTDScanner.scanDTDExternalSubset(true)) {
                        }
                    } else {
                        XMLDocumentScannerMMImpl.this.fDTDScanner.setInputSource(null);
                    }
                }
                finally {
                    XMLDocumentScannerMMImpl.this.fEntityManager.setEntityHandler((XMLEntityHandler)XMLDocumentScannerMMImpl.this);
                }
            }
        }
    }

    protected final class DTDDispatcher
    implements XMLDocumentFragmentScannerMMImpl.Dispatcher {
        protected DTDDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean dispatch(boolean complete) throws IOException, XNIException {
            boolean bl;
            XMLDocumentScannerMMImpl.this.fEntityManager.setEntityHandler(null);
            try {
                boolean again;
                block16: do {
                    again = false;
                    switch (XMLDocumentScannerMMImpl.this.fScannerState) {
                        case 17: {
                            boolean completeDTD = true;
                            boolean readExternalSubset = !(!XMLDocumentScannerMMImpl.this.fValidation && !XMLDocumentScannerMMImpl.this.fLoadExternalDTD || XMLDocumentScannerMMImpl.this.fValidationManager != null && XMLDocumentScannerMMImpl.this.fValidationManager.isCachedDTD());
                            boolean moreToScan = XMLDocumentScannerMMImpl.this.fDTDScanner.scanDTDInternalSubset(completeDTD, XMLDocumentScannerMMImpl.this.fStandalone, XMLDocumentScannerMMImpl.this.fHasExternalDTD && readExternalSubset);
                            if (moreToScan) continue block16;
                            if (!XMLDocumentScannerMMImpl.this.fEntityScanner.skipChar(93)) {
                                XMLDocumentScannerMMImpl.this.reportFatalError("EXPECTED_SQUARE_BRACKET_TO_CLOSE_INTERNAL_SUBSET", null);
                            }
                            XMLDocumentScannerMMImpl.this.fEntityScanner.skipSpaces();
                            if (!XMLDocumentScannerMMImpl.this.fEntityScanner.skipChar(62)) {
                                XMLDocumentScannerMMImpl.this.reportFatalError("DoctypedeclUnterminated", new Object[]{XMLDocumentScannerMMImpl.this.fDoctypeName});
                            }
                            --XMLDocumentScannerMMImpl.this.fMarkupDepth;
                            if (XMLDocumentScannerMMImpl.this.fDoctypeSystemId != null) {
                                boolean bl2 = XMLDocumentScannerMMImpl.this.fIsEntityDeclaredVC = !XMLDocumentScannerMMImpl.this.fStandalone;
                                if (readExternalSubset) {
                                    XMLDocumentScannerMMImpl.this.setScannerState(18);
                                    break;
                                }
                            } else if (XMLDocumentScannerMMImpl.this.fExternalSubsetSource != null) {
                                boolean bl3 = XMLDocumentScannerMMImpl.this.fIsEntityDeclaredVC = !XMLDocumentScannerMMImpl.this.fStandalone;
                                if (readExternalSubset) {
                                    XMLDocumentScannerMMImpl.this.fDTDScanner.setInputSource(XMLDocumentScannerMMImpl.this.fExternalSubsetSource);
                                    XMLDocumentScannerMMImpl.this.fExternalSubsetSource = null;
                                    XMLDocumentScannerMMImpl.this.setScannerState(19);
                                    break;
                                }
                            } else {
                                XMLDocumentScannerMMImpl.this.fIsEntityDeclaredVC = XMLDocumentScannerMMImpl.this.fEntityManager.hasPEReferences() && !XMLDocumentScannerMMImpl.this.fStandalone;
                            }
                            XMLDocumentScannerMMImpl.this.setScannerState(5);
                            XMLDocumentScannerMMImpl.this.setDispatcher(XMLDocumentScannerMMImpl.this.fPrologDispatcher);
                            XMLDocumentScannerMMImpl.this.fEntityManager.setEntityHandler((XMLEntityHandler)XMLDocumentScannerMMImpl.this);
                            boolean bl4 = true;
                            return bl4;
                        }
                        case 18: {
                            XMLDocumentScannerMMImpl.this.fDTDDescription.setValues(XMLDocumentScannerMMImpl.this.fDoctypePublicId, XMLDocumentScannerMMImpl.this.fDoctypeSystemId, null, null);
                            XMLDocumentScannerMMImpl.this.fDTDDescription.setRootName(XMLDocumentScannerMMImpl.this.fDoctypeName);
                            XMLInputSource xmlInputSource = XMLDocumentScannerMMImpl.this.fEntityManager.resolveEntity((XMLResourceIdentifier)XMLDocumentScannerMMImpl.this.fDTDDescription);
                            XMLDocumentScannerMMImpl.this.fDTDScanner.setInputSource(xmlInputSource);
                            XMLDocumentScannerMMImpl.this.setScannerState(19);
                            again = true;
                            break;
                        }
                        case 19: {
                            boolean completeDTD = true;
                            boolean moreToScan = XMLDocumentScannerMMImpl.this.fDTDScanner.scanDTDExternalSubset(completeDTD);
                            if (moreToScan) continue block16;
                            XMLDocumentScannerMMImpl.this.setScannerState(5);
                            XMLDocumentScannerMMImpl.this.setDispatcher(XMLDocumentScannerMMImpl.this.fPrologDispatcher);
                            XMLDocumentScannerMMImpl.this.fEntityManager.setEntityHandler((XMLEntityHandler)XMLDocumentScannerMMImpl.this);
                            boolean bl5 = true;
                            return bl5;
                        }
                        default: {
                            throw new XNIException("DTDDispatcher#dispatch: scanner state=" + XMLDocumentScannerMMImpl.this.fScannerState + " (" + XMLDocumentScannerMMImpl.this.getScannerStateName(XMLDocumentScannerMMImpl.this.fScannerState) + ')');
                        }
                    }
                } while (complete || again);
            }
            catch (MalformedByteSequenceException e) {
                XMLDocumentScannerMMImpl.this.fErrorReporter.reportError(e.getDomain(), e.getKey(), e.getArguments(), (short)2, (Exception)((Object)e));
                bl = false;
                return bl;
            }
            catch (CharConversionException e) {
                XMLDocumentScannerMMImpl.this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "CharConversionFailure", null, (short)2, (Exception)e);
                bl = false;
                return bl;
            }
            catch (EOFException e) {
                XMLDocumentScannerMMImpl.this.reportFatalError("PrematureEOF", null);
                bl = false;
                return bl;
            }
            finally {
                XMLDocumentScannerMMImpl.this.fEntityManager.setEntityHandler((XMLEntityHandler)XMLDocumentScannerMMImpl.this);
            }
            return true;
        }
    }

    protected final class PrologDispatcher
    implements XMLDocumentFragmentScannerMMImpl.Dispatcher {
        protected PrologDispatcher() {
        }

        public boolean dispatch(boolean complete) throws IOException, XNIException {
            try {
                boolean again;
                do {
                    again = false;
                    switch (XMLDocumentScannerMMImpl.this.fScannerState) {
                        case 5: {
                            XMLDocumentScannerMMImpl.this.fEntityScanner.skipSpaces();
                            if (XMLDocumentScannerMMImpl.this.fEntityScanner.skipChar(60)) {
                                XMLDocumentScannerMMImpl.this.setScannerState(1);
                                again = true;
                                break;
                            }
                            if (XMLDocumentScannerMMImpl.this.fEntityScanner.skipChar(38)) {
                                XMLDocumentScannerMMImpl.this.setScannerState(8);
                                again = true;
                                break;
                            }
                            XMLDocumentScannerMMImpl.this.setScannerState(7);
                            again = true;
                            break;
                        }
                        case 1: {
                            ++XMLDocumentScannerMMImpl.this.fMarkupDepth;
                            if (XMLDocumentScannerMMImpl.this.fEntityScanner.skipChar(33)) {
                                if (XMLDocumentScannerMMImpl.this.fEntityScanner.skipChar(45)) {
                                    if (!XMLDocumentScannerMMImpl.this.fEntityScanner.skipChar(45)) {
                                        XMLDocumentScannerMMImpl.this.reportFatalError("InvalidCommentStart", null);
                                    }
                                    XMLDocumentScannerMMImpl.this.setScannerState(2);
                                    again = true;
                                    break;
                                }
                                if (XMLDocumentScannerMMImpl.this.fEntityScanner.skipString("DOCTYPE")) {
                                    XMLDocumentScannerMMImpl.this.setScannerState(4);
                                    again = true;
                                    break;
                                }
                                XMLDocumentScannerMMImpl.this.reportFatalError("MarkupNotRecognizedInProlog", null);
                                break;
                            }
                            if (XMLDocumentScannerMMImpl.this.isValidNameStartChar(XMLDocumentScannerMMImpl.this.fEntityScanner.peekChar())) {
                                XMLDocumentScannerMMImpl.this.setScannerState(6);
                                XMLDocumentScannerMMImpl.this.setDispatcher(XMLDocumentScannerMMImpl.this.fContentDispatcher);
                                return true;
                            }
                            if (XMLDocumentScannerMMImpl.this.fEntityScanner.skipChar(63)) {
                                XMLDocumentScannerMMImpl.this.setScannerState(3);
                                again = true;
                                break;
                            }
                            if (XMLDocumentScannerMMImpl.this.isValidNameStartHighSurrogate(XMLDocumentScannerMMImpl.this.fEntityScanner.peekChar())) {
                                XMLDocumentScannerMMImpl.this.setScannerState(6);
                                XMLDocumentScannerMMImpl.this.setDispatcher(XMLDocumentScannerMMImpl.this.fContentDispatcher);
                                return true;
                            }
                            XMLDocumentScannerMMImpl.this.reportFatalError("MarkupNotRecognizedInProlog", null);
                            break;
                        }
                        case 2: {
                            XMLDocumentScannerMMImpl.this.scanComment();
                            XMLDocumentScannerMMImpl.this.setScannerState(5);
                            break;
                        }
                        case 3: {
                            XMLDocumentScannerMMImpl.this.scanPI();
                            XMLDocumentScannerMMImpl.this.setScannerState(5);
                            break;
                        }
                        case 4: {
                            if (XMLDocumentScannerMMImpl.this.fDisallowDoctype) {
                                XMLDocumentScannerMMImpl.this.reportFatalError("DoctypeNotAllowed", null);
                            }
                            if (XMLDocumentScannerMMImpl.this.fSeenDoctypeDecl) {
                                XMLDocumentScannerMMImpl.this.reportFatalError("AlreadySeenDoctype", null);
                            }
                            XMLDocumentScannerMMImpl.this.fSeenDoctypeDecl = true;
                            if (XMLDocumentScannerMMImpl.this.scanDoctypeDecl()) {
                                XMLDocumentScannerMMImpl.this.setScannerState(17);
                                XMLDocumentScannerMMImpl.this.setDispatcher(XMLDocumentScannerMMImpl.this.fDTDDispatcher);
                                return true;
                            }
                            if (XMLDocumentScannerMMImpl.this.fDoctypeSystemId != null) {
                                boolean bl = XMLDocumentScannerMMImpl.this.fIsEntityDeclaredVC = !XMLDocumentScannerMMImpl.this.fStandalone;
                                if (!(!XMLDocumentScannerMMImpl.this.fValidation && !XMLDocumentScannerMMImpl.this.fLoadExternalDTD || XMLDocumentScannerMMImpl.this.fValidationManager != null && XMLDocumentScannerMMImpl.this.fValidationManager.isCachedDTD())) {
                                    XMLDocumentScannerMMImpl.this.setScannerState(18);
                                    XMLDocumentScannerMMImpl.this.setDispatcher(XMLDocumentScannerMMImpl.this.fDTDDispatcher);
                                    return true;
                                }
                            } else if (XMLDocumentScannerMMImpl.this.fExternalSubsetSource != null) {
                                boolean bl = XMLDocumentScannerMMImpl.this.fIsEntityDeclaredVC = !XMLDocumentScannerMMImpl.this.fStandalone;
                                if (!(!XMLDocumentScannerMMImpl.this.fValidation && !XMLDocumentScannerMMImpl.this.fLoadExternalDTD || XMLDocumentScannerMMImpl.this.fValidationManager != null && XMLDocumentScannerMMImpl.this.fValidationManager.isCachedDTD())) {
                                    XMLDocumentScannerMMImpl.this.fDTDScanner.setInputSource(XMLDocumentScannerMMImpl.this.fExternalSubsetSource);
                                    XMLDocumentScannerMMImpl.this.fExternalSubsetSource = null;
                                    XMLDocumentScannerMMImpl.this.setScannerState(19);
                                    XMLDocumentScannerMMImpl.this.setDispatcher(XMLDocumentScannerMMImpl.this.fDTDDispatcher);
                                    return true;
                                }
                            }
                            XMLDocumentScannerMMImpl.this.fDTDScanner.setInputSource(null);
                            XMLDocumentScannerMMImpl.this.setScannerState(5);
                            break;
                        }
                        case 7: {
                            XMLDocumentScannerMMImpl.this.reportFatalError("ContentIllegalInProlog", null);
                            XMLDocumentScannerMMImpl.this.fEntityScanner.scanChar();
                        }
                        case 8: {
                            XMLDocumentScannerMMImpl.this.reportFatalError("ReferenceIllegalInProlog", null);
                        }
                    }
                } while (complete || again);
                if (complete) {
                    if (XMLDocumentScannerMMImpl.this.fEntityScanner.scanChar() != 60) {
                        XMLDocumentScannerMMImpl.this.reportFatalError("RootElementRequired", null);
                    }
                    XMLDocumentScannerMMImpl.this.setScannerState(6);
                    XMLDocumentScannerMMImpl.this.setDispatcher(XMLDocumentScannerMMImpl.this.fContentDispatcher);
                }
            }
            catch (MalformedByteSequenceException e) {
                XMLDocumentScannerMMImpl.this.fErrorReporter.reportError(e.getDomain(), e.getKey(), e.getArguments(), (short)2, (Exception)((Object)e));
                return false;
            }
            catch (CharConversionException e) {
                XMLDocumentScannerMMImpl.this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "CharConversionFailure", null, (short)2, (Exception)e);
                return false;
            }
            catch (EOFException e) {
                XMLDocumentScannerMMImpl.this.reportFatalError("PrematureEOF", null);
                return false;
            }
            return true;
        }
    }

    protected final class XMLDeclDispatcher
    implements XMLDocumentFragmentScannerMMImpl.Dispatcher {
        protected XMLDeclDispatcher() {
        }

        public boolean dispatch(boolean complete) throws IOException, XNIException {
            XMLDocumentScannerMMImpl.this.setScannerState(5);
            XMLDocumentScannerMMImpl.this.setDispatcher(XMLDocumentScannerMMImpl.this.fPrologDispatcher);
            try {
                if (XMLDocumentScannerMMImpl.this.fEntityScanner.skipString("<?xml")) {
                    ++XMLDocumentScannerMMImpl.this.fMarkupDepth;
                    if (XMLChar.isName((int)XMLDocumentScannerMMImpl.this.fEntityScanner.peekChar())) {
                        XMLDocumentScannerMMImpl.this.fStringBuffer.clear();
                        XMLDocumentScannerMMImpl.this.fStringBuffer.append("xml");
                        if (XMLDocumentScannerMMImpl.this.fNamespaces) {
                            while (XMLChar.isNCName((int)XMLDocumentScannerMMImpl.this.fEntityScanner.peekChar())) {
                                XMLDocumentScannerMMImpl.this.fStringBuffer.append((char)XMLDocumentScannerMMImpl.this.fEntityScanner.scanChar());
                            }
                        } else {
                            while (XMLChar.isName((int)XMLDocumentScannerMMImpl.this.fEntityScanner.peekChar())) {
                                XMLDocumentScannerMMImpl.this.fStringBuffer.append((char)XMLDocumentScannerMMImpl.this.fEntityScanner.scanChar());
                            }
                        }
                        String target = XMLDocumentScannerMMImpl.this.fSymbolTable.addSymbol(((XMLDocumentScannerMMImpl)XMLDocumentScannerMMImpl.this).fStringBuffer.ch, ((XMLDocumentScannerMMImpl)XMLDocumentScannerMMImpl.this).fStringBuffer.offset, ((XMLDocumentScannerMMImpl)XMLDocumentScannerMMImpl.this).fStringBuffer.length);
                        XMLDocumentScannerMMImpl.this.scanPIData(target, XMLDocumentScannerMMImpl.this.fString);
                    } else {
                        XMLDocumentScannerMMImpl.this.scanXMLDeclOrTextDecl(false);
                    }
                }
                XMLDocumentScannerMMImpl.this.fEntityManager.fCurrentEntity.mayReadChunks = true;
                return true;
            }
            catch (MalformedByteSequenceException e) {
                XMLDocumentScannerMMImpl.this.fErrorReporter.reportError(e.getDomain(), e.getKey(), e.getArguments(), (short)2, (Exception)((Object)e));
                return false;
            }
            catch (CharConversionException e) {
                XMLDocumentScannerMMImpl.this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "CharConversionFailure", null, (short)2, (Exception)e);
                return false;
            }
            catch (EOFException e) {
                XMLDocumentScannerMMImpl.this.reportFatalError("PrematureEOF", null);
                return false;
            }
        }
    }
}

