/*
 * Decompiled with CFR 0.152.
 */
package org.flexunit.ant.tasks;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.flexunit.ant.FlexUnitSocketServer;
import org.flexunit.ant.FlexUnitSocketThread;
import org.flexunit.ant.LoggingUtil;
import org.flexunit.ant.launcher.commands.player.AdlCommand;
import org.flexunit.ant.launcher.commands.player.PlayerCommand;
import org.flexunit.ant.launcher.commands.player.PlayerCommandFactory;
import org.flexunit.ant.launcher.contexts.ExecutionContext;
import org.flexunit.ant.launcher.contexts.ExecutionContextFactory;
import org.flexunit.ant.report.Reports;
import org.flexunit.ant.tasks.configuration.TestRunConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRun {
    private final String TRUE = "true";
    private TestRunConfiguration configuration;
    private Project project;
    private Reports reports;

    public TestRun(Project project, TestRunConfiguration testRunConfiguration) {
        this.project = project;
        this.configuration = testRunConfiguration;
        this.reports = new Reports();
    }

    public void run() throws BuildException {
        this.configuration.log();
        try {
            Future<Object> future = this.setupSocketThread();
            PlayerCommand playerCommand = this.obtainPlayer();
            ExecutionContext executionContext = this.obtainContext(playerCommand);
            executionContext.start();
            Process process = playerCommand.launch();
            future.get();
            executionContext.stop(process);
            this.analyzeReports();
        }
        catch (Exception exception) {
            throw new BuildException((Throwable)exception);
        }
    }

    protected PlayerCommand obtainPlayer() {
        PlayerCommand playerCommand = PlayerCommandFactory.createPlayer(this.configuration.getOs(), this.configuration.getPlayer(), this.configuration.getCommand(), this.configuration.isLocalTrusted());
        playerCommand.setProject(this.project);
        playerCommand.setSwf(this.configuration.getSwf());
        playerCommand.setUrl(this.configuration.getUrl());
        if (playerCommand instanceof AdlCommand) {
            ((AdlCommand)playerCommand).setPrecompiledAppDescriptor(this.configuration.getPrecompiledAppDescriptor());
        }
        return playerCommand;
    }

    protected ExecutionContext obtainContext(PlayerCommand playerCommand) {
        ExecutionContext executionContext = ExecutionContextFactory.createContext(this.configuration.getOs(), this.configuration.isHeadless(), this.configuration.getDisplay());
        executionContext.setProject(this.project);
        executionContext.setCommand(playerCommand);
        return executionContext;
    }

    protected Future<Object> setupSocketThread() {
        LoggingUtil.log("Setting up server process ...");
        FlexUnitSocketServer flexUnitSocketServer = new FlexUnitSocketServer(this.configuration.getPort(), this.configuration.getSocketTimeout(), this.configuration.getServerBufferSize(), this.configuration.usePolicyFile());
        FlexUnitSocketThread flexUnitSocketThread = new FlexUnitSocketThread(flexUnitSocketServer, this.configuration.getReportDir(), this.reports);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        return executorService.submit(flexUnitSocketThread);
    }

    protected void analyzeReports() {
        LoggingUtil.log("Analyzing reports ...");
        LoggingUtil.log("\n" + this.reports.getSummary(), true);
        if (this.reports.hasFailures()) {
            this.project.setNewProperty(this.configuration.getFailureProperty(), "true");
            if (this.configuration.isFailOnTestFailure()) {
                throw new BuildException("FlexUnit tests failed during the test run.");
            }
        }
    }
}

