/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.print.table;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.util.PrintSinkOutputWriter;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.print.table.PrintConnectorOptions;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkFunctionProvider;
import org.apache.flink.table.connector.sink.abilities.SupportsPartitioning;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.DataType;

@Internal
public class PrintTableSinkFactory
implements DynamicTableSinkFactory {
    public static final String IDENTIFIER = "print";

    @Override
    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public Set<ConfigOption<?>> requiredOptions() {
        return new HashSet();
    }

    @Override
    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(PrintConnectorOptions.PRINT_IDENTIFIER);
        options.add(PrintConnectorOptions.STANDARD_ERROR);
        options.add(FactoryUtil.SINK_PARALLELISM);
        return options;
    }

    @Override
    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper(this, context);
        helper.validate();
        ReadableConfig options = helper.getOptions();
        return new PrintSink(context.getCatalogTable().getResolvedSchema().toPhysicalRowDataType(), context.getCatalogTable().getPartitionKeys(), (String)options.get(PrintConnectorOptions.PRINT_IDENTIFIER), (Boolean)options.get(PrintConnectorOptions.STANDARD_ERROR), options.getOptional(FactoryUtil.SINK_PARALLELISM).orElse(null));
    }

    private static class RowDataPrintFunction
    extends RichSinkFunction<RowData> {
        private static final long serialVersionUID = 1L;
        private final DynamicTableSink.DataStructureConverter converter;
        private final PrintSinkOutputWriter<String> writer;

        private RowDataPrintFunction(DynamicTableSink.DataStructureConverter converter, String printIdentifier, boolean stdErr) {
            this.converter = converter;
            this.writer = new PrintSinkOutputWriter(printIdentifier, stdErr);
        }

        public void open(OpenContext openContext) throws Exception {
            super.open(openContext);
            StreamingRuntimeContext context = (StreamingRuntimeContext)this.getRuntimeContext();
            this.writer.open(context.getTaskInfo().getIndexOfThisSubtask(), context.getTaskInfo().getNumberOfParallelSubtasks());
        }

        public void invoke(RowData value, SinkFunction.Context context) {
            Object data = this.converter.toExternal(value);
            assert (data != null);
            this.writer.write((Object)data.toString());
        }
    }

    private static class PrintSink
    implements DynamicTableSink,
    SupportsPartitioning {
        private final DataType type;
        private String printIdentifier;
        private final boolean stdErr;
        @Nullable
        private final Integer parallelism;
        private final List<String> partitionKeys;
        private Map<String, String> staticPartitions = new LinkedHashMap<String, String>();

        private PrintSink(DataType type, List<String> partitionKeys, String printIdentifier, boolean stdErr, Integer parallelism) {
            this.type = type;
            this.partitionKeys = partitionKeys;
            this.printIdentifier = printIdentifier;
            this.stdErr = stdErr;
            this.parallelism = parallelism;
        }

        @Override
        public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
            return requestedMode;
        }

        @Override
        public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
            DynamicTableSink.DataStructureConverter converter = context.createDataStructureConverter(this.type);
            this.staticPartitions.forEach((key, value) -> {
                this.printIdentifier = null != this.printIdentifier ? this.printIdentifier + ":" : "";
                this.printIdentifier = this.printIdentifier + key + "=" + value;
            });
            return SinkFunctionProvider.of((SinkFunction<RowData>)new RowDataPrintFunction(converter, this.printIdentifier, this.stdErr), this.parallelism);
        }

        @Override
        public DynamicTableSink copy() {
            return new PrintSink(this.type, this.partitionKeys, this.printIdentifier, this.stdErr, this.parallelism);
        }

        @Override
        public String asSummaryString() {
            return "Print to " + (this.stdErr ? "System.err" : "System.out");
        }

        @Override
        public void applyStaticPartition(Map<String, String> partition) {
            this.staticPartitions = new LinkedHashMap<String, String>();
            for (String partitionCol : this.partitionKeys) {
                if (!partition.containsKey(partitionCol)) continue;
                this.staticPartitions.put(partitionCol, partition.get(partitionCol));
            }
        }
    }
}

