/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.codesplit;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.codesplit.AddBoolBeforeReturnRewriter;
import org.apache.flink.table.codesplit.CodeRewriter;
import org.apache.flink.table.codesplit.CodeSplitUtil;
import org.apache.flink.table.codesplit.JavaLexer;
import org.apache.flink.table.codesplit.JavaParser;
import org.apache.flink.table.codesplit.JavaParserBaseVisitor;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.CharStreams;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.CommonTokenStream;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.ParserRuleContext;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.TokenStreamRewriter;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.apache.flink.table.shaded.org.antlr.v4.runtime.atn.PredictionMode;

@Internal
public class FunctionSplitter
implements CodeRewriter {
    private String code;
    private final int maxMethodLength;

    public FunctionSplitter(String code, int maxMethodLength) {
        this.code = code;
        this.maxMethodLength = maxMethodLength;
    }

    @Override
    public String rewrite() {
        AddBoolBeforeReturnRewriter boolRewriter = new AddBoolBeforeReturnRewriter(this.code, this.maxMethodLength);
        this.code = boolRewriter.rewrite();
        FunctionSplitVisitor visitor = new FunctionSplitVisitor(boolRewriter.getBoolVarNames());
        JavaParser javaParser = new JavaParser(visitor.tokenStream);
        ((ParserATNSimulator)javaParser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        visitor.visit(javaParser.compilationUnit());
        return visitor.rewriter.getText();
    }

    private class FunctionSplitVisitor
    extends JavaParserBaseVisitor<Void> {
        private final CommonTokenStream tokenStream;
        private final TokenStreamRewriter rewriter;
        private final List<Map<String, String>> boolVarNames;
        private int classCount;

        private FunctionSplitVisitor(List<Map<String, String>> boolVarNames) {
            this.tokenStream = new CommonTokenStream(new JavaLexer(CharStreams.fromString(FunctionSplitter.this.code)));
            this.rewriter = new TokenStreamRewriter(this.tokenStream);
            this.boolVarNames = boolVarNames;
            this.classCount = -1;
        }

        @Override
        public Void visitClassBody(JavaParser.ClassBodyContext ctx) {
            ++this.classCount;
            return (Void)this.visitChildren(ctx);
        }

        @Override
        public Void visitConstructorDeclaration(JavaParser.ConstructorDeclarationContext ctx) {
            return this.doFunctionSplit(ctx, ctx.constructorBody, "void", ctx.IDENTIFIER().getText(), CodeSplitUtil.getContextString(ctx.formalParameters()), ctx.THROWS() != null, CodeSplitUtil.getContextString(ctx.qualifiedNameList()));
        }

        @Override
        public Void visitMethodDeclaration(JavaParser.MethodDeclarationContext ctx) {
            if (!"void".equals(ctx.typeTypeOrVoid().getText())) {
                return null;
            }
            return this.doFunctionSplit(ctx, ctx.methodBody().block(), CodeSplitUtil.getContextString(ctx.typeTypeOrVoid()), ctx.IDENTIFIER().getText(), CodeSplitUtil.getContextString(ctx.formalParameters()), ctx.THROWS() != null, CodeSplitUtil.getContextString(ctx.qualifiedNameList()));
        }

        private Void doFunctionSplit(ParserRuleContext ctx, JavaParser.BlockContext blockContext, String returnType, String functionName, String parameters, boolean hasThrowable, String throwables) {
            String hasReturnedVarName;
            long methodBodyLength = CodeSplitUtil.getContextTextLength(blockContext);
            if (methodBodyLength < (long)FunctionSplitter.this.maxMethodLength) {
                return null;
            }
            if (blockContext.blockStatement() == null || blockContext.blockStatement().size() <= 1) {
                return null;
            }
            ArrayList<String> splitFuncBodies = new ArrayList<String>();
            ArrayList<JavaParser.BlockStatementContext> blockStatementContexts = new ArrayList<JavaParser.BlockStatementContext>();
            final LinkedHashSet declarations = new LinkedHashSet();
            new JavaParserBaseVisitor<Void>(){

                @Override
                public Void visitFormalParameter(JavaParser.FormalParameterContext ctx) {
                    declarations.add(ctx.variableDeclaratorId().getText());
                    return null;
                }
            }.visit(ctx);
            for (JavaParser.BlockStatementContext blockStatementContext : blockContext.blockStatement()) {
                blockStatementContexts.add(blockStatementContext);
                splitFuncBodies.add(CodeSplitUtil.getContextString(blockStatementContext));
            }
            List<String> mergedCodeBlocks = this.getMergedCodeBlocks(splitFuncBodies);
            ArrayList<CallSite> newSplitMethods = new ArrayList<CallSite>();
            ArrayList<CallSite> newSplitMethodCalls = new ArrayList<CallSite>();
            Object methodQualifier = "";
            if (hasThrowable) {
                methodQualifier = " throws " + throwables;
            }
            if ((hasReturnedVarName = this.boolVarNames.get(this.classCount).get(functionName + parameters)) != null) {
                this.rewriter.insertAfter(blockContext.start, (Object)String.format("\n%s = false;", hasReturnedVarName));
            }
            for (String methodBody : mergedCodeBlocks) {
                long counter = CodeSplitUtil.getCounter().getAndIncrement();
                String splitMethodDef = returnType + " " + functionName + "_split" + counter + parameters + (String)methodQualifier;
                String newSplitMethod = splitMethodDef + " {\n" + methodBody + "\n}\n";
                String newSplitMethodCall = functionName + "_split" + counter + "(" + String.join((CharSequence)", ", declarations) + ");\n";
                if (hasReturnedVarName != null && newSplitMethod.contains(hasReturnedVarName)) {
                    newSplitMethodCall = newSplitMethodCall + String.format("if (%s) { return; }\n", hasReturnedVarName);
                }
                newSplitMethods.add((CallSite)((Object)newSplitMethod));
                newSplitMethodCalls.add((CallSite)((Object)newSplitMethodCall));
            }
            for (int i = 0; i < blockStatementContexts.size(); ++i) {
                if (i < newSplitMethods.size()) {
                    this.rewriter.replace(((JavaParser.BlockStatementContext)blockStatementContexts.get((int)i)).start, ((JavaParser.BlockStatementContext)blockStatementContexts.get((int)i)).stop, newSplitMethodCalls.get(i));
                    this.rewriter.insertAfter(ctx.getParent().stop, (Object)("\n" + (String)newSplitMethods.get(i)));
                    continue;
                }
                this.rewriter.delete(((JavaParser.BlockStatementContext)blockStatementContexts.get((int)i)).start, ((JavaParser.BlockStatementContext)blockStatementContexts.get((int)i)).stop);
            }
            return null;
        }

        private List<String> getMergedCodeBlocks(List<String> codeBlock) {
            ArrayList<String> mergedCodeBlocks = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            codeBlock.forEach(code -> {
                if (sb.length() + code.length() + 1 <= FunctionSplitter.this.maxMethodLength) {
                    sb.append("\n").append((String)code);
                } else {
                    if (sb.length() > 0) {
                        mergedCodeBlocks.add(sb.toString());
                        sb.delete(0, sb.length());
                    }
                    sb.append((String)code);
                }
            });
            if (sb.length() > 0) {
                mergedCodeBlocks.add(sb.toString());
            }
            return mergedCodeBlocks;
        }
    }
}

