/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.window.utils;

import java.time.ZoneId;
import java.util.IdentityHashMap;
import javax.annotation.Nullable;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.RowDataUtil;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.JoinConditionWithNullFilters;
import org.apache.flink.table.runtime.operators.window.tvf.common.WindowTimerService;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.function.BiConsumerWithException;

public abstract class WindowJoinHelper {
    private static final String LEFT_LATE_ELEMENTS_DROPPED_METRIC_NAME = "leftNumLateRecordsDropped";
    private static final String LEFT_LATE_ELEMENTS_DROPPED_RATE_METRIC_NAME = "leftLateRecordsDroppedRate";
    private static final String RIGHT_LATE_ELEMENTS_DROPPED_METRIC_NAME = "rightNumLateRecordsDropped";
    private static final String RIGHT_LATE_ELEMENTS_DROPPED_RATE_METRIC_NAME = "rightLateRecordsDroppedRate";
    private static final String WATERMARK_LATENCY_METRIC_NAME = "watermarkLatency";
    private final ZoneId shiftTimeZone;
    private final WindowTimerService<Long> windowTimerService;
    protected final RowDataSerializer leftSerializer;
    protected final RowDataSerializer rightSerializer;
    protected final JoinConditionWithNullFilters joinCondition;
    protected final TimestampedCollector<RowData> collector;
    private final WindowJoinProcessor windowJoinProcessor;
    private Meter leftLateRecordsDroppedRate;
    private Meter rightLateRecordsDroppedRate;

    public WindowJoinHelper(RowDataSerializer leftSerializer, RowDataSerializer rightSerializer, ZoneId shiftTimeZone, WindowTimerService<Long> windowTimerService, JoinConditionWithNullFilters joinCondition, TimestampedCollector<RowData> collector, FlinkJoinType joinType) {
        this.leftSerializer = leftSerializer;
        this.rightSerializer = rightSerializer;
        this.shiftTimeZone = shiftTimeZone;
        this.windowTimerService = windowTimerService;
        this.joinCondition = joinCondition;
        this.collector = collector;
        this.windowJoinProcessor = this.getWindowJoinProcessor(joinType);
    }

    public void registerMetric(OperatorMetricGroup metrics) {
        Counter leftNumLateRecordsDropped = metrics.counter(LEFT_LATE_ELEMENTS_DROPPED_METRIC_NAME);
        this.leftLateRecordsDroppedRate = metrics.meter(LEFT_LATE_ELEMENTS_DROPPED_RATE_METRIC_NAME, (Meter)new MeterView(leftNumLateRecordsDropped));
        Counter rightNumLateRecordsDropped = metrics.counter(RIGHT_LATE_ELEMENTS_DROPPED_METRIC_NAME);
        this.rightLateRecordsDroppedRate = metrics.meter(RIGHT_LATE_ELEMENTS_DROPPED_RATE_METRIC_NAME, (Meter)new MeterView(rightNumLateRecordsDropped));
        metrics.gauge(WATERMARK_LATENCY_METRIC_NAME, () -> {
            long watermark = this.windowTimerService.currentWatermark();
            if (watermark < 0L) {
                return 0L;
            }
            return this.windowTimerService.currentProcessingTime() - watermark;
        });
    }

    public void processElement(StreamRecord<RowData> element, int windowEndIndex, Meter lateRecordsDroppedRate, BiConsumerWithException<Long, RowData, Exception> accStateConsumer) throws Exception {
        RowData inputRow = (RowData)element.getValue();
        long windowEnd = inputRow.getLong(windowEndIndex);
        if (TimeWindowUtil.isWindowFired(windowEnd, this.windowTimerService.currentWatermark(), this.shiftTimeZone)) {
            lateRecordsDroppedRate.markEvent();
            return;
        }
        if (!RowDataUtil.isAccumulateMsg(inputRow)) {
            throw new UnsupportedOperationException("This is a bug and should not happen. Please file an issue.");
        }
        accStateConsumer.accept((Object)windowEnd, (Object)inputRow);
        this.windowTimerService.registerEventTimeWindowTimer(windowEnd);
    }

    public void joinAndClear(long windowEnd, @Nullable Iterable<RowData> leftRecords, @Nullable Iterable<RowData> rightRecords) throws Exception {
        this.windowJoinProcessor.doJoin(leftRecords, rightRecords);
        if (leftRecords != null) {
            this.clearState(windowEnd, true);
        }
        if (rightRecords != null) {
            this.clearState(windowEnd, false);
        }
    }

    public Meter getLeftLateRecordsDroppedRate() {
        return this.leftLateRecordsDroppedRate;
    }

    public Meter getRightLateRecordsDroppedRate() {
        return this.rightLateRecordsDroppedRate;
    }

    public abstract void clearState(long var1, boolean var3) throws Exception;

    private WindowJoinProcessor getWindowJoinProcessor(FlinkJoinType joinType) {
        switch (joinType) {
            case INNER: {
                return new InnerWindowJoinProcessor();
            }
            case SEMI: {
                return new SemiAntiWindowJoinProcessor(false);
            }
            case ANTI: {
                return new SemiAntiWindowJoinProcessor(true);
            }
            case LEFT: {
                return new LeftOuterWindowJoinProcessor();
            }
            case RIGHT: {
                return new RightOuterWindowJoinProcessor();
            }
            case FULL: {
                return new FullOuterWindowJoinProcessor();
            }
        }
        throw new IllegalArgumentException("Invalid join type: " + joinType);
    }

    private class FullOuterWindowJoinProcessor
    extends AbstractOuterWindowJoinProcessor {
        private FullOuterWindowJoinProcessor() {
        }

        @Override
        public void doJoin(@Nullable Iterable<RowData> leftRecords, @Nullable Iterable<RowData> rightRecords) {
            if (leftRecords == null && rightRecords == null) {
                return;
            }
            if (rightRecords == null) {
                this.outputNullPadding(leftRecords, true);
            } else if (leftRecords == null) {
                this.outputNullPadding(rightRecords, false);
            } else {
                IdentityHashMap<RowData, Boolean> emittedRightRecords = new IdentityHashMap<RowData, Boolean>();
                for (RowData leftRecord : leftRecords) {
                    boolean matches = false;
                    for (RowData rightRecord : rightRecords) {
                        if (!WindowJoinHelper.this.joinCondition.apply(leftRecord, rightRecord)) continue;
                        this.output(leftRecord, rightRecord, true);
                        matches = true;
                        emittedRightRecords.put(rightRecord, Boolean.TRUE);
                    }
                    if (matches) continue;
                    this.outputNullPadding(leftRecord, true);
                }
                for (RowData rightRecord : rightRecords) {
                    if (emittedRightRecords.containsKey(rightRecord)) continue;
                    this.outputNullPadding(rightRecord, false);
                }
            }
        }
    }

    private class RightOuterWindowJoinProcessor
    extends AbstractOuterWindowJoinProcessor {
        private RightOuterWindowJoinProcessor() {
        }

        @Override
        public void doJoin(@Nullable Iterable<RowData> leftRecords, @Nullable Iterable<RowData> rightRecords) {
            if (rightRecords == null) {
                return;
            }
            if (leftRecords == null) {
                this.outputNullPadding(rightRecords, false);
            } else {
                for (RowData rightRecord : rightRecords) {
                    boolean matches = false;
                    for (RowData leftRecord : leftRecords) {
                        if (!WindowJoinHelper.this.joinCondition.apply(leftRecord, rightRecord)) continue;
                        this.output(leftRecord, rightRecord, true);
                        matches = true;
                    }
                    if (matches) continue;
                    this.outputNullPadding(rightRecord, false);
                }
            }
        }
    }

    private class LeftOuterWindowJoinProcessor
    extends AbstractOuterWindowJoinProcessor {
        private LeftOuterWindowJoinProcessor() {
        }

        @Override
        public void doJoin(@Nullable Iterable<RowData> leftRecords, @Nullable Iterable<RowData> rightRecords) {
            if (leftRecords == null) {
                return;
            }
            if (rightRecords == null) {
                this.outputNullPadding(leftRecords, true);
            } else {
                for (RowData leftRecord : leftRecords) {
                    boolean matches = false;
                    for (RowData rightRecord : rightRecords) {
                        if (!WindowJoinHelper.this.joinCondition.apply(leftRecord, rightRecord)) continue;
                        this.output(leftRecord, rightRecord, true);
                        matches = true;
                    }
                    if (matches) continue;
                    this.outputNullPadding(leftRecord, true);
                }
            }
        }
    }

    private abstract class AbstractOuterWindowJoinProcessor
    implements WindowJoinProcessor {
        private final RowData leftNullRow;
        private final RowData rightNullRow;
        private final JoinedRowData outRow;

        private AbstractOuterWindowJoinProcessor() {
            this.leftNullRow = new GenericRowData(WindowJoinHelper.this.leftSerializer.getArity());
            this.rightNullRow = new GenericRowData(WindowJoinHelper.this.rightSerializer.getArity());
            this.outRow = new JoinedRowData();
        }

        protected void outputNullPadding(RowData row, boolean isLeft) {
            if (isLeft) {
                this.outRow.replace(row, this.rightNullRow);
            } else {
                this.outRow.replace(this.leftNullRow, row);
            }
            this.outRow.setRowKind(RowKind.INSERT);
            WindowJoinHelper.this.collector.collect((Object)this.outRow);
        }

        protected void outputNullPadding(Iterable<RowData> rows, boolean isLeft) {
            for (RowData row : rows) {
                this.outputNullPadding(row, isLeft);
            }
        }

        protected void output(RowData inputRow, RowData otherRow, boolean inputIsLeft) {
            if (inputIsLeft) {
                this.outRow.replace(inputRow, otherRow);
            } else {
                this.outRow.replace(otherRow, inputRow);
            }
            this.outRow.setRowKind(RowKind.INSERT);
            WindowJoinHelper.this.collector.collect((Object)this.outRow);
        }
    }

    private class InnerWindowJoinProcessor
    implements WindowJoinProcessor {
        private final JoinedRowData outRow = new JoinedRowData();

        private InnerWindowJoinProcessor() {
        }

        @Override
        public void doJoin(@Nullable Iterable<RowData> leftRecords, @Nullable Iterable<RowData> rightRecords) {
            if (leftRecords == null || rightRecords == null) {
                return;
            }
            for (RowData leftRecord : leftRecords) {
                for (RowData rightRecord : rightRecords) {
                    if (!WindowJoinHelper.this.joinCondition.apply(leftRecord, rightRecord)) continue;
                    this.outRow.setRowKind(RowKind.INSERT);
                    this.outRow.replace(leftRecord, rightRecord);
                    WindowJoinHelper.this.collector.collect((Object)this.outRow);
                }
            }
        }
    }

    private class SemiAntiWindowJoinProcessor
    implements WindowJoinProcessor {
        private final boolean isAntiJoin;

        public SemiAntiWindowJoinProcessor(boolean isAntiJoin) {
            this.isAntiJoin = isAntiJoin;
        }

        @Override
        public void doJoin(@Nullable Iterable<RowData> leftRecords, @Nullable Iterable<RowData> rightRecords) {
            if (leftRecords == null) {
                return;
            }
            if (rightRecords == null) {
                if (this.isAntiJoin) {
                    for (RowData leftRecord : leftRecords) {
                        WindowJoinHelper.this.collector.collect((Object)leftRecord);
                    }
                }
                return;
            }
            for (RowData leftRecord : leftRecords) {
                boolean matches = false;
                for (RowData rightRecord : rightRecords) {
                    if (!WindowJoinHelper.this.joinCondition.apply(leftRecord, rightRecord)) continue;
                    matches = true;
                    break;
                }
                if (matches) {
                    if (this.isAntiJoin) continue;
                    WindowJoinHelper.this.collector.collect((Object)leftRecord);
                    continue;
                }
                if (!this.isAntiJoin) continue;
                WindowJoinHelper.this.collector.collect((Object)leftRecord);
            }
        }
    }

    private static interface WindowJoinProcessor {
        public void doJoin(@Nullable Iterable<RowData> var1, @Nullable Iterable<RowData> var2);
    }
}

