/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.Collections;
import java.util.List;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.MultipleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecMatch;
import org.apache.flink.table.planner.plan.nodes.exec.spec.MatchSpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.SortSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.runtime.operators.sink.StreamRecordTimestampInserter;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

@ExecNodeMetadata(name="stream-exec-match", version=1, producedTransformations={"timestamp-inserter", "match"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)
public class StreamExecMatch
extends CommonExecMatch
implements StreamExecNode<RowData>,
MultipleTransformationTranslator<RowData> {
    public StreamExecMatch(ReadableConfig tableConfig, MatchSpec matchSpec, InputProperty inputProperty, RowType outputType, String description) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecMatch.class), ExecNodeContext.newPersistedConfig(StreamExecMatch.class, tableConfig), matchSpec, Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecMatch(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="matchSpec") MatchSpec matchSpec, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, matchSpec, inputProperties, (LogicalType)outputType, description);
    }

    @Override
    public void checkOrderKeys(RowType inputRowType) {
        SortSpec orderKeys = this.matchSpec.getOrderKeys();
        if (orderKeys.getFieldSize() == 0) {
            throw new TableException("You must specify either rowtime or proctime for order by.");
        }
        SortSpec.SortFieldSpec timeOrderField = orderKeys.getFieldSpec(0);
        int timeOrderFieldIdx = timeOrderField.getFieldIndex();
        LogicalType timeOrderFieldType = inputRowType.getTypeAt(timeOrderFieldIdx);
        if (!TypeCheckUtils.isRowTime((LogicalType)timeOrderFieldType) && !TypeCheckUtils.isProcTime((LogicalType)timeOrderFieldType)) {
            throw new TableException("You must specify either rowtime or proctime for order by as the first one.");
        }
        if (!orderKeys.getAscendingOrders()[0]) {
            throw new TableException("Primary sort order of a streaming table must be ascending on time.");
        }
    }

    @Override
    public Transformation<RowData> translateOrder(PlannerBase planner, Transformation<RowData> inputTransform, RowType inputRowType, ExecEdge inputEdge, ExecNodeConfig config) {
        SortSpec.SortFieldSpec timeOrderField = this.matchSpec.getOrderKeys().getFieldSpec(0);
        int timeOrderFieldIdx = timeOrderField.getFieldIndex();
        LogicalType timeOrderFieldType = inputRowType.getTypeAt(timeOrderFieldIdx);
        if (TypeCheckUtils.isRowTime((LogicalType)timeOrderFieldType)) {
            int precision = LogicalTypeChecks.getPrecision((LogicalType)timeOrderFieldType);
            OneInputTransformation transform = ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta("timestamp-inserter", String.format("StreamRecordTimestampInserter(rowtime field: %s)", timeOrderFieldIdx), "StreamRecordTimestampInserter", config), new StreamRecordTimestampInserter(timeOrderFieldIdx, precision), inputTransform.getOutputType(), inputTransform.getParallelism(), false);
            if (this.inputsContainSingleton()) {
                transform.setParallelism(1);
                transform.setMaxParallelism(1);
            }
            return transform;
        }
        return inputTransform;
    }
}

