/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned.rebalance;

import java.util.Map;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.partitioned.PartitionedRegionRebalanceOp;
import org.apache.geode.internal.cache.partitioned.rebalance.BucketOperator;

public class BucketOperatorImpl
implements BucketOperator {
    private final PartitionedRegionRebalanceOp rebalanceOp;

    public BucketOperatorImpl(PartitionedRegionRebalanceOp rebalanceOp) {
        this.rebalanceOp = rebalanceOp;
    }

    @Override
    public boolean moveBucket(InternalDistributedMember source, InternalDistributedMember target, int bucketId, Map<String, Long> colocatedRegionBytes) {
        InternalResourceManager.getResourceObserver().movingBucket(this.rebalanceOp.getLeaderRegion(), bucketId, source, target);
        return this.rebalanceOp.moveBucketForRegion(source, target, bucketId);
    }

    @Override
    public boolean movePrimary(InternalDistributedMember source, InternalDistributedMember target, int bucketId) {
        InternalResourceManager.getResourceObserver().movingPrimary(this.rebalanceOp.getLeaderRegion(), bucketId, source, target);
        return this.rebalanceOp.movePrimaryBucketForRegion(target, bucketId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createRedundantBucket(InternalDistributedMember targetMember, int bucketId, Map<String, Long> colocatedRegionBytes, BucketOperator.Completion completion) {
        boolean result = false;
        try {
            result = this.rebalanceOp.createRedundantBucketForRegion(targetMember, bucketId);
        }
        finally {
            if (result) {
                completion.onSuccess();
            } else {
                completion.onFailure();
            }
        }
    }

    @Override
    public void waitForOperations() {
    }

    @Override
    public boolean removeBucket(InternalDistributedMember targetMember, int bucketId, Map<String, Long> colocatedRegionBytes) {
        return this.rebalanceOp.removeRedundantBucketForRegion(targetMember, bucketId);
    }
}

