/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.rmiio;

import com.healthmarketscience.rmiio.RemoteIteratorClient;
import com.healthmarketscience.rmiio.RemoteIteratorServer;
import com.healthmarketscience.rmiio.exporter.RemoteStreamExporter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialRemoteIteratorClient<DataType>
extends RemoteIteratorClient<DataType>
implements Serializable {
    private static final long serialVersionUID = 3979308768398733924L;
    private transient ObjectInputStream _objIStream;

    public SerialRemoteIteratorClient(RemoteIteratorServer<DataType> server) throws IOException {
        this(server, null);
    }

    public SerialRemoteIteratorClient(RemoteIteratorServer<DataType> server, RemoteStreamExporter exporter) throws IOException {
        super(server, exporter);
    }

    @Override
    protected void initialize(InputStream istream) throws IOException {
        this._objIStream = new ObjectInputStream(istream);
    }

    @Override
    protected DataType readNextObject() throws IOException {
        try {
            return (DataType)this.deserializeObject(this._objIStream);
        }
        catch (ClassNotFoundException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    @Override
    protected void closeIterator() throws IOException {
        if (this._objIStream != null) {
            this._objIStream.close();
        }
        super.closeIterator();
    }

    protected Object deserializeObject(ObjectInputStream istream) throws IOException, ClassNotFoundException {
        return istream.readUnshared();
    }
}

