/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.client.internal;

import org.apache.geode.cache.client.internal.AbstractOp;
import org.apache.geode.cache.client.internal.ConnectionStats;
import org.apache.geode.cache.client.internal.ExecutablePool;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.pdx.internal.EnumInfo;
import org.jetbrains.annotations.NotNull;

public class AddPDXEnumOp {
    public static void execute(ExecutablePool pool, int id, EnumInfo ei) {
        AddPdxEnumOpImpl op = new AddPdxEnumOpImpl(id, ei);
        pool.execute(op);
    }

    private AddPDXEnumOp() {
    }

    private static class AddPdxEnumOpImpl
    extends AbstractOp {
        public AddPdxEnumOpImpl(int id, EnumInfo ei) {
            super(96, 2);
            this.getMessage().addObjPart(ei);
            this.getMessage().addIntPart(id);
        }

        @Override
        protected Object processResponse(@NotNull Message msg) throws Exception {
            this.processAck(msg, "addPDXEnum");
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return false;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startAddPdxType();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endAddPdxTypeSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endAddPdxType(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected boolean participateInTransaction() {
            return false;
        }
    }
}

