/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.AmbiguousNameException;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.CompiledID;
import org.apache.geode.cache.query.internal.CompiledLiteral;
import org.apache.geode.cache.query.internal.CompiledOperation;
import org.apache.geode.cache.query.internal.CompiledPath;
import org.apache.geode.cache.query.internal.CompiledRegion;
import org.apache.geode.cache.query.internal.CompiledSortCriterion;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.Filter;
import org.apache.geode.cache.query.internal.IndexConditioningHelper;
import org.apache.geode.cache.query.internal.IndexInfo;
import org.apache.geode.cache.query.internal.Indexable;
import org.apache.geode.cache.query.internal.LinkedResultSet;
import org.apache.geode.cache.query.internal.LinkedStructSet;
import org.apache.geode.cache.query.internal.PlanInfo;
import org.apache.geode.cache.query.internal.QRegion;
import org.apache.geode.cache.query.internal.QueryExecutionContext;
import org.apache.geode.cache.query.internal.QueryObserver;
import org.apache.geode.cache.query.internal.QueryObserverHolder;
import org.apache.geode.cache.query.internal.QueryUtils;
import org.apache.geode.cache.query.internal.ResultsSet;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.SortedResultsBag;
import org.apache.geode.cache.query.internal.Support;
import org.apache.geode.cache.query.internal.index.IndexData;
import org.apache.geode.cache.query.internal.index.IndexProtocol;
import org.apache.geode.cache.query.internal.index.IndexUtils;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.internal.types.TypeUtils;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.cache.query.types.StructType;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.pdx.internal.PdxString;
import org.apache.logging.log4j.Logger;

public class CompiledIn
extends AbstractCompiledValue
implements Indexable {
    private static final Logger logger = LogService.getLogger();
    private final CompiledValue elm;
    private final CompiledValue colln;

    public CompiledIn(CompiledValue elm, CompiledValue colln) {
        this.elm = elm;
        this.colln = colln;
    }

    @Override
    public List getChildren() {
        ArrayList<CompiledValue> list = new ArrayList<CompiledValue>();
        list.add(this.elm);
        list.add(this.colln);
        return list;
    }

    @Override
    public int getType() {
        return 78;
    }

    private Object evaluateColln(ExecutionContext context) throws QueryInvocationTargetException, NameResolutionException, TypeMismatchException, FunctionDomainException {
        Object evalColln = null;
        if (this.colln.isDependentOnCurrentScope(context)) {
            evalColln = this.colln.evaluate(context);
        } else {
            evalColln = context.cacheGet(this.colln);
            if (evalColln == null) {
                evalColln = this.colln.evaluate(context);
                context.cachePut(this.colln, evalColln);
            }
        }
        return evalColln;
    }

    @Override
    public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Object evalElm = this.elm.evaluate(context);
        Set evalColln = this.evaluateColln(context);
        if (evalColln == null || evalColln == QueryService.UNDEFINED) {
            return QueryService.UNDEFINED;
        }
        if (evalColln instanceof Map) {
            evalColln = ((Map)((Object)evalColln)).entrySet();
        }
        if (evalColln instanceof Collection) {
            for (Object o : (Iterable)evalColln) {
                Object evalObj = evalElm;
                Object collnObj = o;
                if (evalElm instanceof PdxString && collnObj instanceof String) {
                    evalObj = evalElm.toString();
                } else if (collnObj instanceof PdxString && evalElm instanceof String) {
                    collnObj = collnObj.toString();
                }
                if (!TypeUtils.compare(evalObj, collnObj, 13).equals(Boolean.TRUE)) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (!evalColln.getClass().isArray()) {
            throw new TypeMismatchException(String.format("Operand of IN cannot be interpreted as a Collection. Is instance of %s", evalColln.getClass().getName()));
        }
        if (evalColln.getClass().getComponentType().isPrimitive() && evalElm == null) {
            throw new TypeMismatchException("IN operator, check for null IN primitive array");
        }
        int numElements = Array.getLength(evalColln);
        for (int i = 0; i < numElements; ++i) {
            Object o = Array.get(evalColln, i);
            if (!TypeUtils.compare(evalElm, o, 13).equals(Boolean.TRUE)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public IndexInfo[] getIndexInfo(ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        IndexInfo[] indexInfo = this.privGetIndexInfo(context);
        if (indexInfo != null) {
            if (indexInfo == NO_INDEXES_IDENTIFIER) {
                return null;
            }
            return indexInfo;
        }
        if (!IndexUtils.indexesEnabled) {
            return null;
        }
        PathAndKey pAndK = this.getPathAndKey(context);
        IndexInfo[] newIndexInfo = null;
        if (pAndK != null) {
            CompiledValue path = pAndK._path;
            CompiledValue indexKey = pAndK._key;
            IndexData indexData = QueryUtils.getAvailableIndexIfAny(path, context, 13);
            IndexProtocol index = null;
            if (indexData != null) {
                index = indexData.getIndex();
            }
            if (index != null && index.isValid()) {
                newIndexInfo = new IndexInfo[]{new IndexInfo(indexKey, path, index, indexData.getMatchLevel(), indexData.getMapping(), 13)};
            }
        }
        if (newIndexInfo != null) {
            this.privSetIndexInfo(newIndexInfo, context);
        } else {
            this.privSetIndexInfo(NO_INDEXES_IDENTIFIER, context);
        }
        return newIndexInfo;
    }

    private IndexInfo[] privGetIndexInfo(ExecutionContext context) {
        return (IndexInfo[])context.cacheGet(this);
    }

    private void privSetIndexInfo(IndexInfo[] indexInfo, ExecutionContext context) {
        context.cachePut(this, indexInfo);
    }

    @Override
    protected PlanInfo protGetPlanInfo(ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        PlanInfo result = new PlanInfo();
        IndexInfo[] indexInfo = this.getIndexInfo(context);
        if (indexInfo == null) {
            return result;
        }
        for (IndexInfo info : indexInfo) {
            result.indexes.add(info._index);
        }
        result.evalAsFilter = true;
        String preferredCondn = (String)context.cacheGet("preferred_index_condition");
        if (preferredCondn != null && indexInfo[0]._index.getCanonicalizedIndexedExpression().equals(preferredCondn) && (indexInfo[0]._index.getType() == IndexType.FUNCTIONAL || indexInfo[0]._index.getType() == IndexType.HASH)) {
            result.isPreferred = true;
        }
        return result;
    }

    @Override
    public Set computeDependencies(ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        context.addDependencies(this, this.elm.computeDependencies(context));
        return context.addDependencies(this, this.colln.computeDependencies(context));
    }

    List optimizeBulkGet(CompiledRegion cRgn, ExecutionContext context) throws TypeMismatchException, NameResolutionException, FunctionDomainException, QueryInvocationTargetException {
        CompiledOperation cOp;
        boolean match = false;
        CompiledValue resolution = null;
        if (this.elm instanceof CompiledID) {
            String id = ((CompiledID)this.elm).getId();
            if ((id.equals("key") || id.equals("getKey")) && (resolution = context.resolve(id)) instanceof CompiledPath) {
                resolution = resolution.getReceiver();
            }
        } else if (this.elm instanceof CompiledPath) {
            CompiledValue cVal;
            CompiledPath cPath = (CompiledPath)this.elm;
            if ((cPath.getTailID().equals("key") || cPath.getTailID().equals("getKey")) && (cVal = cPath.getReceiver()) instanceof CompiledID) {
                resolution = context.resolve(((CompiledID)cVal).getId());
            }
        } else if (this.elm instanceof CompiledOperation && ((cOp = (CompiledOperation)this.elm).getMethodName().equals("key") || cOp.getMethodName().equals("getKey"))) {
            if (cOp.getReceiver(context) instanceof CompiledID) {
                resolution = context.resolve(((CompiledID)cOp.getReceiver(context)).getId());
            } else if (cOp.getReceiver(context) == null) {
                match = true;
            }
        }
        if (!match && !(resolution instanceof RuntimeIterator)) {
            return null;
        }
        if (context.isDependentOnAnyIterator(this.colln)) {
            return null;
        }
        Object evalColln = this.evaluateColln(context);
        if (evalColln == null || evalColln == QueryService.UNDEFINED) {
            return null;
        }
        List<Object> colln = null;
        if (evalColln instanceof Collection) {
            colln = (List<Object>)evalColln;
        }
        if (evalColln instanceof Object[]) {
            colln = Arrays.asList((Object[])evalColln);
        }
        if (colln != null) {
            QRegion rgn = (QRegion)cRgn.evaluate(context);
            if (rgn.keySet().size() < colln.size()) {
                return null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Executing BULK GET on keys {}, in region {}", colln, (Object)rgn);
            }
            ArrayList<Region.Entry> results = new ArrayList<Region.Entry>(colln.size());
            for (Object e : colln) {
                Region.Entry entry = rgn.getEntry(e);
                if (entry == null) continue;
                results.add(entry);
            }
            return results;
        }
        return null;
    }

    private PathAndKey getPathAndKey(ExecutionContext context) throws TypeMismatchException, AmbiguousNameException {
        boolean isLeftDependent = context.isDependentOnCurrentScope(this.elm);
        boolean isRightDependent = context.isDependentOnCurrentScope(this.colln);
        if (!isLeftDependent || isRightDependent) {
            return null;
        }
        CompiledValue path = this.elm;
        CompiledValue indexKey = this.colln;
        return new PathAndKey(path, indexKey);
    }

    @Override
    public SelectResults filterEvaluate(ExecutionContext context, SelectResults intermediateResults, boolean completeExpansionNeeded, CompiledValue iterOperands, RuntimeIterator[] indpndntItrs, boolean isIntersection, boolean conditioningNeeded, boolean evalProj) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (!this.isDependentOnCurrentScope(context)) {
            return super.filterEvaluate(context, intermediateResults);
        }
        IndexInfo[] idxInfo = this.getIndexInfo(context);
        Support.Assert(idxInfo != null, "a comparison that is dependent, not indexed, and filter evaluated is not possible");
        Support.Assert(idxInfo.length == 1, "In operator should have only one index");
        return this.singleBaseCollectionFilterEvaluate(context, intermediateResults, completeExpansionNeeded, iterOperands, idxInfo[0], indpndntItrs, isIntersection, conditioningNeeded, evalProj);
    }

    @Override
    public int getOperator() {
        return 13;
    }

    private void queryIndex(Object key, IndexInfo indexInfo, SelectResults results, CompiledValue iterOperands, RuntimeIterator[] indpndntItrs, ExecutionContext context, List projAttrib, boolean conditioningNeeded) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        assert (indexInfo != null);
        assert (indexInfo._index != null);
        IndexInfo contextIndexInfo = new IndexInfo(new CompiledLiteral(key), indexInfo._path(), indexInfo._getIndex(), 0, null, indexInfo._operator());
        context.cachePut("index_info", contextIndexInfo);
        indexInfo._index.query(key, 13, results, !conditioningNeeded ? iterOperands : null, indpndntItrs == null ? null : indpndntItrs[0], context, projAttrib, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SelectResults singleBaseCollectionFilterEvaluate(ExecutionContext context, SelectResults intermediateResults, boolean completeExpansionNeeded, CompiledValue iterOperands, IndexInfo indexInfo, RuntimeIterator[] indpndntItr, boolean isIntersection, boolean conditioningNeeded, boolean evalProj) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        ObjectType resultType = indexInfo._index.getResultSetType();
        int indexFieldsSize = -1;
        Collection results = null;
        indexFieldsSize = resultType instanceof StructType ? ((StructTypeImpl)resultType).getFieldNames().length : 1;
        boolean useLinkedDataStructure = false;
        boolean nullValuesAtStart = true;
        Boolean orderByClause = (Boolean)context.cacheGet("can_apply_orderby_at_index");
        if (orderByClause != null && orderByClause.booleanValue()) {
            List orderByAttrs = (List)context.cacheGet("orderby");
            useLinkedDataStructure = orderByAttrs.size() == 1;
            nullValuesAtStart = !((CompiledSortCriterion)orderByAttrs.get(0)).getCriterion();
        }
        List projAttrib = null;
        ObjectType projResultType = null;
        if (!conditioningNeeded) {
            ObjectType objectType = projResultType = evalProj ? (ObjectType)context.cacheGet("result_type") : null;
            if (projResultType != null) {
                resultType = projResultType;
                context.cachePut("result_type", Boolean.TRUE);
                projAttrib = (List)context.cacheGet("projection");
            }
            if (isIntersection) {
                if (resultType instanceof StructType) {
                    context.getCache().getLogger().fine("StructType resultType.class=" + resultType.getClass().getName());
                    results = useLinkedDataStructure ? (context.isDistinct() ? new LinkedStructSet((StructTypeImpl)resultType) : new SortedResultsBag(resultType, nullValuesAtStart)) : QueryUtils.createStructCollection(context, (StructTypeImpl)resultType);
                    indexFieldsSize = ((StructTypeImpl)resultType).getFieldNames().length;
                } else {
                    context.getCache().getLogger().fine("non-StructType resultType.class=" + resultType.getClass().getName());
                    results = useLinkedDataStructure ? (context.isDistinct() ? new LinkedResultSet(resultType) : new SortedResultsBag(resultType, nullValuesAtStart)) : QueryUtils.createResultCollection(context, resultType);
                    indexFieldsSize = 1;
                }
            } else if (intermediateResults != null && !completeExpansionNeeded) {
                results = intermediateResults;
            } else if (resultType instanceof StructType) {
                context.getCache().getLogger().fine("StructType resultType.class=" + resultType.getClass().getName());
                results = useLinkedDataStructure ? (context.isDistinct() ? new LinkedStructSet((StructTypeImpl)resultType) : new SortedResultsBag(resultType, nullValuesAtStart)) : QueryUtils.createStructCollection(context, (StructTypeImpl)resultType);
                indexFieldsSize = ((StructTypeImpl)resultType).getFieldNames().length;
            } else {
                context.getCache().getLogger().fine("non-StructType resultType.class=" + resultType.getClass().getName());
                results = useLinkedDataStructure ? (context.isDistinct() ? new LinkedResultSet(resultType) : new SortedResultsBag(resultType, nullValuesAtStart)) : QueryUtils.createResultCollection(context, resultType);
                indexFieldsSize = 1;
            }
        } else if (resultType instanceof StructType) {
            context.getCache().getLogger().fine("StructType resultType.class=" + resultType.getClass().getName());
            results = useLinkedDataStructure ? (context.isDistinct() ? new LinkedStructSet((StructTypeImpl)resultType) : new SortedResultsBag(resultType, nullValuesAtStart)) : QueryUtils.createStructCollection(context, (StructTypeImpl)resultType);
            indexFieldsSize = ((StructTypeImpl)resultType).getFieldNames().length;
        } else {
            context.getCache().getLogger().fine("non-StructType resultType.class=" + resultType.getClass().getName());
            results = useLinkedDataStructure ? (context.isDistinct() ? new LinkedResultSet(resultType) : new SortedResultsBag(resultType, nullValuesAtStart)) : QueryUtils.createResultCollection(context, resultType);
            indexFieldsSize = 1;
        }
        QueryObserver observer = QueryObserverHolder.getInstance();
        try {
            Object evalColln = this.evaluateColln(context);
            observer.beforeIndexLookup(indexInfo._index, 13, evalColln);
            if (!conditioningNeeded && projResultType != null) {
                resultType = projResultType;
                context.cachePut("result_type", Boolean.TRUE);
            }
            if (evalColln instanceof Map) {
                for (Map.Entry o : ((Map)evalColln).entrySet()) {
                    this.queryIndex(o, indexInfo, (SelectResults)results, iterOperands, indpndntItr, context, projAttrib, conditioningNeeded);
                }
            } else if (evalColln instanceof Collection) {
                Object key = indexInfo.evaluateIndexKey(context);
                if (key instanceof Object[]) {
                    for (Object o : (Iterable)((Object[])key)[0]) {
                        this.queryIndex(new Object[]{o, ((Object[])key)[1]}, indexInfo, (SelectResults)results, iterOperands, indpndntItr, context, projAttrib, conditioningNeeded);
                    }
                } else {
                    HashSet set = new HashSet((Collection)evalColln);
                    for (Object o : set) {
                        this.queryIndex(o, indexInfo, (SelectResults)results, iterOperands, indpndntItr, context, projAttrib, conditioningNeeded);
                    }
                }
            } else {
                if (!evalColln.getClass().isArray()) {
                    throw new TypeMismatchException("Operand of IN cannot be interpreted as a Collection. Is instance of " + evalColln.getClass().getName());
                }
                int evalCollnLength = Array.getLength(evalColln);
                for (int i = 0; i < evalCollnLength; ++i) {
                    this.queryIndex(Array.get(evalColln, i), indexInfo, (SelectResults)results, iterOperands, indpndntItr, context, projAttrib, conditioningNeeded);
                }
            }
            if (conditioningNeeded) {
                results = QueryUtils.getConditionedIndexResults(results, indexInfo, context, indexFieldsSize, completeExpansionNeeded, iterOperands, indpndntItr);
            } else if (isIntersection && intermediateResults != null) {
                results = QueryUtils.intersection(intermediateResults, results, context);
            }
            SelectResults selectResults = results;
            return selectResults;
        }
        finally {
            observer.afterIndexLookup(results);
        }
    }

    @Override
    public boolean isProjectionEvaluationAPossibility(ExecutionContext context) {
        return true;
    }

    @Override
    public boolean isLimitApplicableAtIndexLevel(ExecutionContext context) {
        return true;
    }

    @Override
    public boolean isOrderByApplicableAtIndexLevel(ExecutionContext context, String canonicalizedOrderByClause) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return false;
    }

    @Override
    public boolean isConditioningNeededForIndex(RuntimeIterator independentIter, ExecutionContext context, boolean completeExpnsNeeded) throws TypeMismatchException, NameResolutionException {
        IndexConditioningHelper ich = null;
        IndexInfo[] idxInfo = this.getIndexInfo(context);
        assert (idxInfo.length == 1);
        int indexFieldsSize = -1;
        boolean conditioningNeeded = true;
        ObjectType indexRsltType = idxInfo[0]._index.getResultSetType();
        indexFieldsSize = indexRsltType instanceof StructType ? ((StructTypeImpl)indexRsltType).getFieldNames().length : 1;
        if (independentIter != null && indexFieldsSize == 1) {
            ich = new IndexConditioningHelper(idxInfo[0], context, indexFieldsSize, completeExpnsNeeded, null, independentIter);
        }
        conditioningNeeded = ich == null || ich.shufflingNeeded;
        return conditioningNeeded;
    }

    @Override
    public SelectResults filterEvaluate(ExecutionContext context, SelectResults intermediateResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        RuntimeIterator[] runtimeIteratorArray;
        RuntimeIterator indpndntItr = null;
        List currentScopeIndpndntItrs = context.getAllIndependentIteratorsOfCurrentScope();
        Set rntmItrs = QueryUtils.getCurrentScopeUltimateRuntimeIteratorsIfAny(this, context);
        if (rntmItrs.size() == 1 && currentScopeIndpndntItrs.size() == 1) {
            indpndntItr = (RuntimeIterator)rntmItrs.iterator().next();
        }
        if (indpndntItr != null) {
            RuntimeIterator[] runtimeIteratorArray2 = new RuntimeIterator[1];
            runtimeIteratorArray = runtimeIteratorArray2;
            runtimeIteratorArray2[0] = indpndntItr;
        } else {
            runtimeIteratorArray = null;
        }
        return this.filterEvaluate(context, intermediateResults, true, null, runtimeIteratorArray, true, this.isConditioningNeededForIndex(indpndntItr, context, true), true);
    }

    @Override
    public SelectResults auxFilterEvaluate(ExecutionContext context, SelectResults intermediateResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Support.assertionFailed(" This auxFilterEvaluate of CompiledIn should never have got invoked.");
        return null;
    }

    @Override
    public boolean isBetterFilter(Filter comparedTo, ExecutionContext context, int thisSize) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        boolean isThisBetter = true;
        int thatSize = comparedTo.getSizeEstimate(context);
        int thatOperator = comparedTo.getOperator();
        if (context instanceof QueryExecutionContext && ((QueryExecutionContext)context).hasHints()) {
            return thisSize <= thatSize;
        }
        switch (thatOperator) {
            case 13: 
            case 20: 
            case 21: {
                isThisBetter = thisSize < thatSize;
                break;
            }
            case 91: {
                break;
            }
            case 18: 
            case 19: 
            case 22: 
            case 23: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The operator type =" + thatOperator + " is unknown");
            }
        }
        return isThisBetter;
    }

    @Override
    public int getSizeEstimate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        QueryExecutionContext qcontext;
        IndexInfo[] idxInfo = this.getIndexInfo(context);
        if (idxInfo == null) {
            return 0;
        }
        assert (idxInfo.length == 1);
        Object key = idxInfo[0].evaluateIndexKey(context);
        if (key != null && key.equals(QueryService.UNDEFINED)) {
            return 0;
        }
        if (context instanceof QueryExecutionContext && (qcontext = (QueryExecutionContext)context).isHinted(idxInfo[0]._index.getName())) {
            return qcontext.getHintSize(idxInfo[0]._index.getName());
        }
        Object evalColln = this.evaluateColln(context);
        int size = 0;
        if (evalColln instanceof Map) {
            for (Map.Entry o : ((Map)evalColln).entrySet()) {
                size += idxInfo[0]._index.getSizeEstimate(o, 13, idxInfo[0]._matchLevel);
            }
        } else if (evalColln instanceof Collection) {
            if (key instanceof Object[]) {
                for (Object o : (ResultsSet)((Object[])key)[0]) {
                    size += idxInfo[0]._index.getSizeEstimate(new Object[]{o, ((Object[])key)[1]}, 13, idxInfo[0]._matchLevel);
                }
            } else {
                for (Object o : (Collection)evalColln) {
                    size += idxInfo[0]._index.getSizeEstimate(o, 13, idxInfo[0]._matchLevel);
                }
            }
        } else {
            if (!evalColln.getClass().isArray()) {
                throw new TypeMismatchException("Operand of IN cannot be interpreted as a Collection. Is instance of " + evalColln.getClass().getName());
            }
            if (evalColln instanceof Object[]) {
                Object[] arr;
                for (Object o : arr = (Object[])evalColln) {
                    size += idxInfo[0]._index.getSizeEstimate(o, 13, idxInfo[0]._matchLevel);
                }
            } else if (evalColln instanceof long[]) {
                long[] a;
                for (long l : a = (long[])evalColln) {
                    size += idxInfo[0]._index.getSizeEstimate(l, 13, idxInfo[0]._matchLevel);
                }
            } else if (evalColln instanceof double[]) {
                double[] a;
                for (double v : a = (double[])evalColln) {
                    size += idxInfo[0]._index.getSizeEstimate(v, 13, idxInfo[0]._matchLevel);
                }
            } else if (evalColln instanceof float[]) {
                float[] a;
                for (float v : a = (float[])evalColln) {
                    size += idxInfo[0]._index.getSizeEstimate(Float.valueOf(v), 13, idxInfo[0]._matchLevel);
                }
            } else if (evalColln instanceof int[]) {
                int[] a;
                for (int j : a = (int[])evalColln) {
                    size += idxInfo[0]._index.getSizeEstimate(j, 13, idxInfo[0]._matchLevel);
                }
            } else if (evalColln instanceof short[]) {
                short[] a;
                for (short value : a = (short[])evalColln) {
                    size += idxInfo[0]._index.getSizeEstimate(value, 13, idxInfo[0]._matchLevel);
                }
            } else if (evalColln instanceof char[]) {
                char[] a;
                for (char c : a = (char[])evalColln) {
                    size += idxInfo[0]._index.getSizeEstimate(Character.valueOf(c), 13, idxInfo[0]._matchLevel);
                }
            } else if (evalColln instanceof byte[]) {
                byte[] a;
                for (byte b : a = (byte[])evalColln) {
                    size += idxInfo[0]._index.getSizeEstimate(b, 13, idxInfo[0]._matchLevel);
                }
            } else {
                throw new TypeMismatchException("Operand of IN cannot be interpreted as a Comparable Object. Operand is of type =" + evalColln.getClass());
            }
        }
        return size;
    }

    @Override
    public boolean isRangeEvaluatable() {
        return false;
    }

    static class PathAndKey {
        CompiledValue _path;
        CompiledValue _key;

        PathAndKey(CompiledValue path, CompiledValue indexKey) {
            this._path = path;
            this._key = indexKey;
        }
    }
}

