/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.admin.remote;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.GemFireCacheException;
import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.Region;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.internal.admin.remote.RegionAdminMessage;
import org.apache.geode.internal.admin.remote.SnapshotResultMessage;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class AppCacheSnapshotMessage
extends RegionAdminMessage {
    private int snapshotId;

    public static AppCacheSnapshotMessage create(String regionName, int snapshotId) {
        AppCacheSnapshotMessage m = new AppCacheSnapshotMessage();
        m.setRegionName(regionName);
        m.snapshotId = snapshotId;
        return m;
    }

    @Override
    protected void process(ClusterDistributionManager dm) {
        Region r = this.getRegion(dm.getSystem());
        if (r != null) {
            try {
                SnapshotResultMessage m = SnapshotResultMessage.create(r, this.snapshotId);
                m.setRecipient(this.getSender());
                dm.putOutgoing(m);
            }
            catch (CacheException ex) {
                throw new GemFireCacheException(ex);
            }
        }
    }

    public int getDSFID() {
        return 1009;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.snapshotId);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.snapshotId = in.readInt();
    }

    @Override
    public String toString() {
        return "AppCacheSnapshotMessage from " + this.getSender();
    }
}

