/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.locks;

import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.locks.DLockBatch;
import org.apache.geode.distributed.internal.locks.DLockGrantor;
import org.apache.geode.distributed.internal.locks.DLockLessorDepartureHandler;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.locks.TXLockBatch;
import org.apache.geode.internal.cache.locks.TXLockService;
import org.apache.geode.internal.cache.locks.TXLockServiceImpl;
import org.apache.geode.internal.cache.locks.TXOriginatorRecoveryProcessor;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class TXLessorDepartureHandler
implements DLockLessorDepartureHandler {
    private static final Logger logger = LogService.getLogger();
    private final Object stateLock = new Object();
    private boolean processingDepartures;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForInProcessDepartures() throws InterruptedException {
        Object object = this.stateLock;
        synchronized (object) {
            while (this.processingDepartures) {
                this.stateLock.wait();
            }
        }
    }

    @Override
    public void handleDepartureOf(InternalDistributedMember owner, DLockGrantor grantor) {
        TXLockService dtls = TXLockService.getDTLS();
        if (dtls == null) {
            return;
        }
        try {
            if (!dtls.isLockGrantor()) {
                logger.debug("This member is not lock grantor; exiting TXLessorDepartureHandler");
                return;
            }
            DLockService dlock = ((TXLockServiceImpl)dtls).getInternalDistributedLockService();
            if (grantor == null || grantor.isDestroyed()) {
                logger.debug("Lock grantor does not exist or has been destroyed; exiting TXLessorDepartureHandler");
                return;
            }
            DLockBatch[] batches = grantor.getLockBatches(owner);
            if (batches.length == 0) {
                logger.debug("{} has no active lock batches; exiting TXLessorDepartureHandler", (Object)owner);
                return;
            }
            this.sendRecoveryMsgs(dlock.getDistributionManager(), batches, owner, grantor);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRecoveryMsgs(DistributionManager dm, DLockBatch[] batches, InternalDistributedMember owner, DLockGrantor grantor) {
        block5: {
            Object object = this.stateLock;
            synchronized (object) {
                this.processingDepartures = true;
            }
            Runnable recoverTx = () -> {
                try {
                    for (DLockBatch dLockBatch : batches) {
                        TXLockBatch batch = (TXLockBatch)dLockBatch;
                        Set participants = batch.getParticipants();
                        TXOriginatorRecoveryProcessor.sendMessage(participants, owner, batch.getTXLockId(), grantor, dm);
                    }
                }
                finally {
                    this.clearProcessingDepartures();
                }
            };
            try {
                dm.getExecutors().getWaitingThreadPool().execute(recoverTx);
            }
            catch (RejectedExecutionException e) {
                if (dm.getCancelCriterion().isCancelInProgress()) break block5;
                logger.warn("Unable to schedule background cleanup of transactions for departed member {}.  Performing in-line cleanup of the transactions.");
                recoverTx.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearProcessingDepartures() {
        Object object = this.stateLock;
        synchronized (object) {
            this.processingDepartures = false;
            this.stateLock.notifyAll();
        }
    }
}

