/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned.colocation;

import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.colocation.ColocationLogger;
import org.apache.geode.internal.cache.partitioned.colocation.SingleThreadColocationLoggerFactory;
import org.apache.geode.internal.classloader.ClassPathLoader;

@FunctionalInterface
public interface ColocationLoggerFactory {
    @VisibleForTesting
    public static final String COLOCATION_LOGGER_FACTORY_PROPERTY = "geode.ColocationLoggerFactory";

    public static ColocationLoggerFactory create() {
        try {
            String className = System.getProperty(COLOCATION_LOGGER_FACTORY_PROPERTY, SingleThreadColocationLoggerFactory.class.getName());
            return (ColocationLoggerFactory)ClassPathLoader.getLatest().forName(className).newInstance();
        }
        catch (Exception e) {
            return new SingleThreadColocationLoggerFactory();
        }
    }

    public ColocationLogger startColocationLogger(PartitionedRegion var1);
}

