/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util.concurrent;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class CopyOnWriteWeakHashMap<K, V>
extends AbstractMap<K, V> {
    private volatile Map<K, V> map = Collections.emptyMap();

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public synchronized V put(K key, V value) {
        WeakHashMap<K, V> tmp = new WeakHashMap<K, V>(this.map);
        V result = tmp.put(key, value);
        this.map = Collections.unmodifiableMap(tmp);
        return result;
    }

    @Override
    public synchronized V putIfAbsent(K key, V value) {
        V oldValue = this.map.get(key);
        if (oldValue != null) {
            return oldValue;
        }
        WeakHashMap<K, V> tmp = new WeakHashMap<K, V>(this.map);
        V result = tmp.put(key, value);
        this.map = Collections.unmodifiableMap(tmp);
        return result;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> m) {
        WeakHashMap<? extends K, ? extends V> tmp = new WeakHashMap<K, V>(this.map);
        tmp.putAll(m);
        this.map = Collections.unmodifiableMap(tmp);
    }

    @Override
    public synchronized V remove(Object key) {
        WeakHashMap<K, V> tmp = new WeakHashMap<K, V>(this.map);
        V result = tmp.remove(key);
        this.map = Collections.unmodifiableMap(tmp);
        return result;
    }

    @Override
    public synchronized void clear() {
        this.map = Collections.emptyMap();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }
}

