/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mdn;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.james.mdn.fields.Disposition;
import org.apache.james.mdn.fields.Error;
import org.apache.james.mdn.fields.ExtensionField;
import org.apache.james.mdn.fields.Field;
import org.apache.james.mdn.fields.FinalRecipient;
import org.apache.james.mdn.fields.Gateway;
import org.apache.james.mdn.fields.OriginalMessageId;
import org.apache.james.mdn.fields.OriginalRecipient;
import org.apache.james.mdn.fields.ReportingUserAgent;
import org.apache.james.mdn.fields.Text;
import org.apache.james.util.StreamUtils;

public class MDNReport {
    public static final String LINE_END = "\r\n";
    public static final String EXTENSION_DELIMITER = "\r\n";
    private final Optional<ReportingUserAgent> reportingUserAgentField;
    private final Optional<Gateway> gatewayField;
    private final Optional<OriginalRecipient> originalRecipientField;
    private final FinalRecipient finalRecipientField;
    private final Optional<OriginalMessageId> originalMessageIdField;
    private final Disposition dispositionField;
    private final ImmutableList<Error> errorFields;
    private final ImmutableList<ExtensionField> extensionFields;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    MDNReport(Optional<ReportingUserAgent> reportingUserAgentField, Optional<Gateway> gatewayField, Optional<OriginalRecipient> originalRecipientField, FinalRecipient finalRecipientField, Optional<OriginalMessageId> originalMessageIdField, Disposition dispositionField, ImmutableList<Error> errorFields, ImmutableList<ExtensionField> extensionFields) {
        this.reportingUserAgentField = reportingUserAgentField;
        this.gatewayField = gatewayField;
        this.originalRecipientField = originalRecipientField;
        this.finalRecipientField = finalRecipientField;
        this.originalMessageIdField = originalMessageIdField;
        this.dispositionField = dispositionField;
        this.errorFields = errorFields;
        this.extensionFields = extensionFields;
    }

    public Optional<ReportingUserAgent> getReportingUserAgentField() {
        return this.reportingUserAgentField;
    }

    public Optional<OriginalRecipient> getOriginalRecipientField() {
        return this.originalRecipientField;
    }

    public FinalRecipient getFinalRecipientField() {
        return this.finalRecipientField;
    }

    public Optional<OriginalMessageId> getOriginalMessageIdField() {
        return this.originalMessageIdField;
    }

    public Disposition getDispositionField() {
        return this.dispositionField;
    }

    public Optional<Gateway> getGatewayField() {
        return this.gatewayField;
    }

    public List<Error> getErrorFields() {
        return this.errorFields;
    }

    public ImmutableList<ExtensionField> getExtensionFields() {
        return this.extensionFields;
    }

    public String formattedValue() {
        Stream<Optional> definedFields = Stream.of(this.reportingUserAgentField, this.gatewayField, this.originalRecipientField, Optional.of(this.finalRecipientField), this.originalMessageIdField, Optional.of(this.dispositionField));
        Stream<Optional> errors = this.errorFields.stream().map(Optional::of);
        Stream<Optional> extentions = this.extensionFields.stream().map(Optional::of);
        return StreamUtils.flatten(Stream.of(definedFields, errors, extentions)).flatMap(Optional::stream).map(Field::formattedValue).collect(Collectors.joining("\r\n")) + "\r\n";
    }

    public final boolean equals(Object o) {
        if (o instanceof MDNReport) {
            MDNReport that = (MDNReport)o;
            return Objects.equals(this.reportingUserAgentField, that.reportingUserAgentField) && Objects.equals(this.dispositionField, that.dispositionField) && Objects.equals(this.errorFields, that.errorFields) && Objects.equals(this.finalRecipientField, that.finalRecipientField) && Objects.equals(this.gatewayField, that.gatewayField) && Objects.equals(this.originalMessageIdField, that.originalMessageIdField) && Objects.equals(this.extensionFields, that.extensionFields) && Objects.equals(this.originalRecipientField, that.originalRecipientField);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.reportingUserAgentField, this.gatewayField, this.originalMessageIdField, this.originalRecipientField, this.dispositionField, this.errorFields, this.extensionFields, this.finalRecipientField);
    }

    public String toString() {
        return this.formattedValue();
    }

    public static class Builder {
        private Optional<ReportingUserAgent> reportingUserAgentField = Optional.empty();
        private Optional<Gateway> gatewayField = Optional.empty();
        private Optional<OriginalRecipient> originalRecipientField = Optional.empty();
        private Optional<FinalRecipient> finalRecipientField = Optional.empty();
        private Optional<OriginalMessageId> originalMessageIdField = Optional.empty();
        private Optional<Disposition> dispositionField = Optional.empty();
        private ImmutableList.Builder<Error> errorField = ImmutableList.builder();
        private ImmutableList.Builder<ExtensionField> extensionFields = ImmutableList.builder();

        public Builder reportingUserAgentField(ReportingUserAgent reportingUserAgentField) {
            this.reportingUserAgentField = Optional.of(reportingUserAgentField);
            return this;
        }

        public Builder originalRecipientField(String originalRecipient) {
            this.originalRecipientField = Optional.ofNullable(originalRecipient).map(Text::fromRawText).map(text -> OriginalRecipient.builder().originalRecipient((Text)text).build());
            return this;
        }

        public Builder originalRecipientField(OriginalRecipient originalRecipientField) {
            this.originalRecipientField = Optional.of(originalRecipientField);
            return this;
        }

        public Builder originalRecipientField(Optional<OriginalRecipient> originalRecipientField) {
            this.originalRecipientField = originalRecipientField;
            return this;
        }

        public Builder gatewayField(Gateway gatewayField) {
            this.gatewayField = Optional.of(gatewayField);
            return this;
        }

        public Builder addErrorField(String message) {
            this.errorField.add((Object)new Error(Text.fromRawText(message)));
            return this;
        }

        public Builder addErrorField(Error errorField) {
            this.errorField.add((Object)errorField);
            return this;
        }

        public Builder addErrorFields(Error ... errorField) {
            this.errorField.add(errorField);
            return this;
        }

        public Builder finalRecipientField(String finalRecipientField) {
            this.finalRecipientField = Optional.of(FinalRecipient.builder().finalRecipient(Text.fromRawText(finalRecipientField)).build());
            return this;
        }

        public Builder finalRecipientField(FinalRecipient finalRecipientField) {
            this.finalRecipientField = Optional.of(finalRecipientField);
            return this;
        }

        public Builder originalMessageIdField(String originalMessageIdField) {
            this.originalMessageIdField = Optional.of(new OriginalMessageId(originalMessageIdField));
            return this;
        }

        public Builder originalMessageIdField(OriginalMessageId originalMessageIdField) {
            this.originalMessageIdField = Optional.of(originalMessageIdField);
            return this;
        }

        public Builder dispositionField(Disposition dispositionField) {
            this.dispositionField = Optional.of(dispositionField);
            return this;
        }

        public Builder withExtensionField(ExtensionField extensionField) {
            this.extensionFields.add((Object)extensionField);
            return this;
        }

        public Builder withExtensionFields(ExtensionField ... extensionField) {
            this.extensionFields.add(extensionField);
            return this;
        }

        public MDNReport build() {
            Preconditions.checkState(this.finalRecipientField.isPresent());
            Preconditions.checkState(this.dispositionField.isPresent());
            return new MDNReport(this.reportingUserAgentField, this.gatewayField, this.originalRecipientField, this.finalRecipientField.get(), this.originalMessageIdField, this.dispositionField.get(), (ImmutableList<Error>)this.errorField.build(), (ImmutableList<ExtensionField>)this.extensionFields.build());
        }
    }
}

