/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config.map;

import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.OptionsMap;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.config.ConfigChangeEvent;
import com.datastax.oss.driver.internal.core.config.map.MapBasedDriverConfig;
import com.datastax.oss.driver.internal.core.context.EventBus;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;

public class MapBasedDriverConfigLoader
implements DriverConfigLoader,
Consumer<OptionsMap> {
    @NonNull
    private final OptionsMap source;
    @NonNull
    private final Map<String, Map<DriverOption, Object>> rawMap;
    private volatile EventBus eventBus;

    public MapBasedDriverConfigLoader(@NonNull OptionsMap source, @NonNull Map<String, Map<DriverOption, Object>> rawMap) {
        this.source = source;
        this.rawMap = rawMap;
    }

    @Override
    @NonNull
    public DriverConfig getInitialConfig() {
        return new MapBasedDriverConfig(this.rawMap);
    }

    @Override
    public void onDriverInit(@NonNull DriverContext context) {
        this.eventBus = ((InternalDriverContext)context).getEventBus();
        this.source.addChangeListener(this);
    }

    @Override
    public void accept(OptionsMap map) {
        assert (this.eventBus != null);
        this.eventBus.fire((Object)ConfigChangeEvent.INSTANCE);
    }

    @Override
    @NonNull
    public CompletionStage<Boolean> reload() {
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public boolean supportsReloading() {
        return true;
    }

    @Override
    public void close() {
        this.source.removeChangeListener(this);
    }
}

