/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.activemq;

import jakarta.inject.Inject;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Session;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class ActiveMQHealthCheck
implements HealthCheck {
    public static final Logger LOGGER = LoggerFactory.getLogger(ActiveMQHealthCheck.class);
    public static final ComponentName COMPONENT_NAME = new ComponentName("Embedded ActiveMQ");
    private final ConnectionFactory connectionFactory;

    @Inject
    public ActiveMQHealthCheck(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Publisher<Result> check() {
        return Mono.fromCallable(() -> {
            try {
                try (Connection connection = this.connectionFactory.createConnection();){
                    Session session = connection.createSession(true, 0);
                    session.close();
                }
                return Result.healthy((ComponentName)COMPONENT_NAME);
            }
            catch (Exception e) {
                LOGGER.warn("{} is unhealthy. {}", (Object)COMPONENT_NAME.getName(), (Object)e.getMessage());
                return Result.unhealthy((ComponentName)COMPONENT_NAME, (String)e.toString(), (Throwable)e);
            }
        }).subscribeOn(Schedulers.boundedElastic());
    }
}

