/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.api;

import jakarta.mail.MessagingException;
import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.util.streams.Iterators;
import org.apache.mailet.Mail;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public interface MailRepository {
    public long size() throws MessagingException;

    default public Publisher<Long> sizeReactive() {
        return Mono.fromCallable(this::size);
    }

    public MailKey store(Mail var1) throws MessagingException;

    public Iterator<MailKey> list() throws MessagingException;

    default public Iterator<MailKey> list(Condition condition) throws MessagingException {
        if (Condition.ALL.equals(condition)) {
            return this.list();
        }
        return Iterators.toStream(this.list()).filter(key -> {
            try {
                Mail mail = this.retrieve((MailKey)key);
                return condition.test(mail);
            }
            catch (MessagingException e) {
                throw new RuntimeException(e);
            }
        }).iterator();
    }

    public Mail retrieve(MailKey var1) throws MessagingException;

    public void remove(MailKey var1) throws MessagingException;

    default public void remove(Collection<MailKey> keys) throws MessagingException {
        for (MailKey key : keys) {
            this.remove(key);
        }
    }

    public void removeAll() throws MessagingException;

    public static interface Condition
    extends Predicate<Mail> {
        public static final Condition ALL = any -> true;

        default public Condition and(Condition other) {
            return mail -> this.test(mail) && other.test(mail);
        }
    }

    public static class RemoteHostCondition
    implements Condition {
        private final String remoteHost;

        public RemoteHostCondition(String remoteHost) {
            this.remoteHost = remoteHost;
        }

        @Override
        public boolean test(Mail mail) {
            return mail.getRemoteHost().equalsIgnoreCase(this.remoteHost);
        }
    }

    public static class RemoteAddressCondition
    implements Condition {
        private final String remoteAddress;

        public RemoteAddressCondition(String remoteAddress) {
            this.remoteAddress = remoteAddress;
        }

        @Override
        public boolean test(Mail mail) {
            return mail.getRemoteAddr().equalsIgnoreCase(this.remoteAddress);
        }
    }

    public static class RecipientCondition
    implements Condition {
        private final String recipient;

        public RecipientCondition(String recipient) {
            this.recipient = recipient;
        }

        @Override
        public boolean test(Mail mail) {
            if (this.recipient.startsWith("*@")) {
                String domain = this.recipient.substring(2).toLowerCase();
                return mail.getRecipients().stream().anyMatch(address -> address.asString().toLowerCase().endsWith("@" + domain));
            }
            return mail.getRecipients().stream().anyMatch(address -> address.asString().equalsIgnoreCase(this.recipient));
        }
    }

    public static class SenderCondition
    implements Condition {
        private final String sender;

        public SenderCondition(String sender) {
            this.sender = sender;
        }

        @Override
        public boolean test(Mail mail) {
            if (this.sender.startsWith("*@")) {
                String domain = this.sender.substring(2).toLowerCase();
                return mail.getMaybeSender().asOptional().map(mailAddress -> mailAddress.asString().toLowerCase().endsWith("@" + domain)).orElse(false);
            }
            return mail.getMaybeSender().asOptional().map(mailAddress -> mailAddress.asString().equalsIgnoreCase(this.sender)).orElse(false);
        }
    }

    public static class UpdatedAfterCondition
    implements Condition {
        private final Instant updatedAfter;

        public UpdatedAfterCondition(Instant updatedAfter) {
            this.updatedAfter = updatedAfter;
        }

        @Override
        public boolean test(Mail mail) {
            return mail.getLastUpdated().toInstant().isAfter(this.updatedAfter);
        }
    }

    public static class UpdatedBeforeCondition
    implements Condition {
        private final Instant updatedBefore;

        public UpdatedBeforeCondition(Instant updatedBefore) {
            this.updatedBefore = updatedBefore;
        }

        @Override
        public boolean test(Mail mail) {
            return mail.getLastUpdated().toInstant().isBefore(this.updatedBefore);
        }
    }
}

