/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.util.Objects;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class RemoteLogSegmentId {
    private final TopicIdPartition topicIdPartition;
    private final Uuid id;

    public static RemoteLogSegmentId generateNew(TopicIdPartition topicIdPartition) {
        return new RemoteLogSegmentId(topicIdPartition, Uuid.randomUuid());
    }

    public RemoteLogSegmentId(TopicIdPartition topicIdPartition, Uuid id) {
        this.topicIdPartition = Objects.requireNonNull(topicIdPartition, "topicIdPartition can not be null");
        this.id = Objects.requireNonNull(id, "id can not be null");
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public Uuid id() {
        return this.id;
    }

    public String toString() {
        return "RemoteLogSegmentId{topicIdPartition=" + this.topicIdPartition + ", id=" + this.id + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteLogSegmentId that = (RemoteLogSegmentId)o;
        return Objects.equals(this.topicIdPartition, that.topicIdPartition) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.topicIdPartition, this.id);
    }
}

