/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.config;

import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.Utils;

public class ShareGroupConfig {
    public static final String SHARE_GROUP_ENABLE_CONFIG = "group.share.enable";
    public static final boolean SHARE_GROUP_ENABLE_DEFAULT = false;
    public static final String SHARE_GROUP_ENABLE_DOC = "Enable share groups on the broker.";
    public static final String SHARE_GROUP_PARTITION_MAX_RECORD_LOCKS_CONFIG = "group.share.partition.max.record.locks";
    public static final int SHARE_GROUP_PARTITION_MAX_RECORD_LOCKS_DEFAULT = 200;
    public static final String SHARE_GROUP_PARTITION_MAX_RECORD_LOCKS_DOC = "Share-group record lock limit per share-partition.";
    public static final String SHARE_GROUP_DELIVERY_COUNT_LIMIT_CONFIG = "group.share.delivery.count.limit";
    public static final int SHARE_GROUP_DELIVERY_COUNT_LIMIT_DEFAULT = 5;
    public static final String SHARE_GROUP_DELIVERY_COUNT_LIMIT_DOC = "The maximum number of delivery attempts for a record delivered to a share group.";
    public static final String SHARE_GROUP_MAX_GROUPS_CONFIG = "group.share.max.groups";
    public static final short SHARE_GROUP_MAX_GROUPS_DEFAULT = 10;
    public static final String SHARE_GROUP_MAX_GROUPS_DOC = "The maximum number of share groups.";
    public static final String SHARE_GROUP_RECORD_LOCK_DURATION_MS_CONFIG = "group.share.record.lock.duration.ms";
    public static final int SHARE_GROUP_RECORD_LOCK_DURATION_MS_DEFAULT = 30000;
    public static final String SHARE_GROUP_RECORD_LOCK_DURATION_MS_DOC = "The record acquisition lock duration in milliseconds for share groups.";
    public static final String SHARE_GROUP_MIN_RECORD_LOCK_DURATION_MS_CONFIG = "group.share.min.record.lock.duration.ms";
    public static final int SHARE_GROUP_MIN_RECORD_LOCK_DURATION_MS_DEFAULT = 15000;
    public static final String SHARE_GROUP_MIN_RECORD_LOCK_DURATION_MS_DOC = "The record acquisition lock minimum duration in milliseconds for share groups.";
    public static final String SHARE_GROUP_MAX_RECORD_LOCK_DURATION_MS_CONFIG = "group.share.max.record.lock.duration.ms";
    public static final int SHARE_GROUP_MAX_RECORD_LOCK_DURATION_MS_DEFAULT = 60000;
    public static final String SHARE_GROUP_MAX_RECORD_LOCK_DURATION_MS_DOC = "The record acquisition lock maximum duration in milliseconds for share groups.";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().defineInternal("group.share.enable", ConfigDef.Type.BOOLEAN, (Object)false, null, ConfigDef.Importance.MEDIUM, "Enable share groups on the broker.").define("group.share.delivery.count.limit", ConfigDef.Type.INT, (Object)5, (ConfigDef.Validator)ConfigDef.Range.between((Number)2, (Number)10), ConfigDef.Importance.MEDIUM, "The maximum number of delivery attempts for a record delivered to a share group.").define("group.share.record.lock.duration.ms", ConfigDef.Type.INT, (Object)30000, (ConfigDef.Validator)ConfigDef.Range.between((Number)1000, (Number)60000), ConfigDef.Importance.MEDIUM, "The record acquisition lock duration in milliseconds for share groups.").define("group.share.min.record.lock.duration.ms", ConfigDef.Type.INT, (Object)15000, (ConfigDef.Validator)ConfigDef.Range.between((Number)1000, (Number)30000), ConfigDef.Importance.MEDIUM, "The record acquisition lock minimum duration in milliseconds for share groups.").define("group.share.max.record.lock.duration.ms", ConfigDef.Type.INT, (Object)60000, (ConfigDef.Validator)ConfigDef.Range.between((Number)30000, (Number)3600000), ConfigDef.Importance.MEDIUM, "The record acquisition lock maximum duration in milliseconds for share groups.").define("group.share.max.groups", ConfigDef.Type.SHORT, (Object)10, (ConfigDef.Validator)ConfigDef.Range.between((Number)1, (Number)100), ConfigDef.Importance.MEDIUM, "The maximum number of share groups.").define("group.share.partition.max.record.locks", ConfigDef.Type.INT, (Object)200, (ConfigDef.Validator)ConfigDef.Range.between((Number)100, (Number)10000), ConfigDef.Importance.MEDIUM, "Share-group record lock limit per share-partition.");
    private final boolean isShareGroupEnabled;
    private final int shareGroupPartitionMaxRecordLocks;
    private final int shareGroupDeliveryCountLimit;
    private final short shareGroupMaxGroups;
    private final int shareGroupRecordLockDurationMs;
    private final int shareGroupMaxRecordLockDurationMs;
    private final int shareGroupMinRecordLockDurationMs;

    public ShareGroupConfig(AbstractConfig config) {
        this.isShareGroupEnabled = config.getBoolean(SHARE_GROUP_ENABLE_CONFIG);
        this.shareGroupPartitionMaxRecordLocks = config.getInt(SHARE_GROUP_PARTITION_MAX_RECORD_LOCKS_CONFIG);
        this.shareGroupDeliveryCountLimit = config.getInt(SHARE_GROUP_DELIVERY_COUNT_LIMIT_CONFIG);
        this.shareGroupMaxGroups = config.getShort(SHARE_GROUP_MAX_GROUPS_CONFIG);
        this.shareGroupRecordLockDurationMs = config.getInt(SHARE_GROUP_RECORD_LOCK_DURATION_MS_CONFIG);
        this.shareGroupMaxRecordLockDurationMs = config.getInt(SHARE_GROUP_MAX_RECORD_LOCK_DURATION_MS_CONFIG);
        this.shareGroupMinRecordLockDurationMs = config.getInt(SHARE_GROUP_MIN_RECORD_LOCK_DURATION_MS_CONFIG);
        this.validate();
    }

    public boolean isShareGroupEnabled() {
        return this.isShareGroupEnabled;
    }

    public int shareGroupPartitionMaxRecordLocks() {
        return this.shareGroupPartitionMaxRecordLocks;
    }

    public int shareGroupDeliveryCountLimit() {
        return this.shareGroupDeliveryCountLimit;
    }

    public short shareGroupMaxGroups() {
        return this.shareGroupMaxGroups;
    }

    public int shareGroupRecordLockDurationMs() {
        return this.shareGroupRecordLockDurationMs;
    }

    public int shareGroupMaxRecordLockDurationMs() {
        return this.shareGroupMaxRecordLockDurationMs;
    }

    public int shareGroupMinRecordLockDurationMs() {
        return this.shareGroupMinRecordLockDurationMs;
    }

    private void validate() {
        Utils.require((this.shareGroupRecordLockDurationMs >= this.shareGroupMinRecordLockDurationMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equals to %s", SHARE_GROUP_RECORD_LOCK_DURATION_MS_CONFIG, SHARE_GROUP_MIN_RECORD_LOCK_DURATION_MS_CONFIG));
        Utils.require((this.shareGroupMaxRecordLockDurationMs >= this.shareGroupRecordLockDurationMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equals to %s", SHARE_GROUP_MAX_RECORD_LOCK_DURATION_MS_CONFIG, SHARE_GROUP_RECORD_LOCK_DURATION_MS_CONFIG));
    }
}

