/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.Utils;
import org.apache.kafka.coordinator.group.api.assignor.SubscriptionType;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.ModernGroupMember;
import org.apache.kafka.coordinator.group.modern.TopicMetadata;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.apache.kafka.timeline.TimelineInteger;
import org.apache.kafka.timeline.TimelineObject;

public abstract class ModernGroup<T extends ModernGroupMember>
implements Group {
    protected final SnapshotRegistry snapshotRegistry;
    protected final String groupId;
    protected final TimelineInteger groupEpoch;
    protected final TimelineHashMap<String, T> members;
    protected final TimelineHashMap<String, Integer> subscribedTopicNames;
    protected final TimelineHashMap<String, TopicMetadata> subscribedTopicMetadata;
    protected final TimelineObject<SubscriptionType> subscriptionType;
    protected final TimelineInteger targetAssignmentEpoch;
    protected final TimelineHashMap<String, Assignment> targetAssignment;
    private final TimelineHashMap<Uuid, TimelineHashMap<Integer, String>> invertedTargetAssignment;
    protected final TimelineHashMap<Uuid, TimelineHashMap<Integer, Integer>> currentPartitionEpoch;
    protected DeadlineAndEpoch metadataRefreshDeadline = DeadlineAndEpoch.EMPTY;

    protected ModernGroup(SnapshotRegistry snapshotRegistry, String groupId) {
        this.snapshotRegistry = Objects.requireNonNull(snapshotRegistry);
        this.groupId = Objects.requireNonNull(groupId);
        this.groupEpoch = new TimelineInteger(snapshotRegistry);
        this.members = new TimelineHashMap(snapshotRegistry, 0);
        this.subscribedTopicNames = new TimelineHashMap(snapshotRegistry, 0);
        this.subscribedTopicMetadata = new TimelineHashMap(snapshotRegistry, 0);
        this.subscriptionType = new TimelineObject(snapshotRegistry, (Object)SubscriptionType.HOMOGENEOUS);
        this.targetAssignmentEpoch = new TimelineInteger(snapshotRegistry);
        this.targetAssignment = new TimelineHashMap(snapshotRegistry, 0);
        this.invertedTargetAssignment = new TimelineHashMap(snapshotRegistry, 0);
        this.currentPartitionEpoch = new TimelineHashMap(snapshotRegistry, 0);
    }

    @Override
    public ListGroupsResponseData.ListedGroup asListedGroup(long committedOffset) {
        return new ListGroupsResponseData.ListedGroup().setGroupId(this.groupId).setProtocolType(this.protocolType()).setGroupState(this.stateAsString(committedOffset)).setGroupType(this.type().toString());
    }

    @Override
    public String groupId() {
        return this.groupId;
    }

    public int groupEpoch() {
        return this.groupEpoch.get();
    }

    public void setGroupEpoch(int groupEpoch) {
        this.groupEpoch.set(groupEpoch);
        this.maybeUpdateGroupState();
    }

    public int assignmentEpoch() {
        return this.targetAssignmentEpoch.get();
    }

    public void setTargetAssignmentEpoch(int targetAssignmentEpoch) {
        this.targetAssignmentEpoch.set(targetAssignmentEpoch);
        this.maybeUpdateGroupState();
    }

    @Override
    public boolean hasMember(String memberId) {
        return this.members.containsKey((Object)memberId);
    }

    @Override
    public int numMembers() {
        return this.members.size();
    }

    public Map<String, T> members() {
        return Collections.unmodifiableMap(this.members);
    }

    public Map<String, Integer> subscribedTopicNames() {
        return Collections.unmodifiableMap(this.subscribedTopicNames);
    }

    @Override
    public boolean isSubscribedToTopic(String topic) {
        return this.subscribedTopicNames.containsKey((Object)topic);
    }

    public SubscriptionType subscriptionType() {
        return (SubscriptionType)this.subscriptionType.get();
    }

    public Assignment targetAssignment(String memberId) {
        return (Assignment)this.targetAssignment.getOrDefault((Object)memberId, (Object)Assignment.EMPTY);
    }

    public Map<Uuid, Map<Integer, String>> invertedTargetAssignment() {
        return Collections.unmodifiableMap(this.invertedTargetAssignment);
    }

    public void updateTargetAssignment(String memberId, Assignment newTargetAssignment) {
        this.updateInvertedTargetAssignment(memberId, (Assignment)this.targetAssignment.getOrDefault((Object)memberId, (Object)new Assignment(Collections.emptyMap())), newTargetAssignment);
        this.targetAssignment.put((Object)memberId, (Object)newTargetAssignment);
    }

    private void updateInvertedTargetAssignment(String memberId, Assignment oldTargetAssignment, Assignment newTargetAssignment) {
        HashSet<Uuid> allTopicIds = new HashSet<Uuid>();
        allTopicIds.addAll(oldTargetAssignment.partitions().keySet());
        allTopicIds.addAll(newTargetAssignment.partitions().keySet());
        for (Uuid topicId : allTopicIds) {
            Set oldPartitions = oldTargetAssignment.partitions().getOrDefault(topicId, Collections.emptySet());
            Set newPartitions = newTargetAssignment.partitions().getOrDefault(topicId, Collections.emptySet());
            TimelineHashMap topicPartitionAssignment = (TimelineHashMap)this.invertedTargetAssignment.computeIfAbsent((Object)topicId, k -> new TimelineHashMap(this.snapshotRegistry, Math.max(oldPartitions.size(), newPartitions.size())));
            for (Integer partition : oldPartitions) {
                if (newPartitions.contains(partition) || !memberId.equals(topicPartitionAssignment.get((Object)partition))) continue;
                topicPartitionAssignment.remove((Object)partition);
            }
            for (Integer partition : newPartitions) {
                if (oldPartitions.contains(partition)) continue;
                topicPartitionAssignment.put((Object)partition, (Object)memberId);
            }
            if (topicPartitionAssignment.isEmpty()) {
                this.invertedTargetAssignment.remove((Object)topicId);
                continue;
            }
            this.invertedTargetAssignment.put((Object)topicId, (Object)topicPartitionAssignment);
        }
    }

    public void removeTargetAssignment(String memberId) {
        this.updateInvertedTargetAssignment(memberId, (Assignment)this.targetAssignment.getOrDefault((Object)memberId, (Object)Assignment.EMPTY), Assignment.EMPTY);
        this.targetAssignment.remove((Object)memberId);
    }

    public Map<String, Assignment> targetAssignment() {
        return Collections.unmodifiableMap(this.targetAssignment);
    }

    public int currentPartitionEpoch(Uuid topicId, int partitionId) {
        Map partitions = (Map)this.currentPartitionEpoch.get((Object)topicId);
        if (partitions == null) {
            return -1;
        }
        return partitions.getOrDefault(partitionId, -1);
    }

    public Map<String, TopicMetadata> subscriptionMetadata() {
        return Collections.unmodifiableMap(this.subscribedTopicMetadata);
    }

    public void setSubscriptionMetadata(Map<String, TopicMetadata> subscriptionMetadata) {
        this.subscribedTopicMetadata.clear();
        this.subscribedTopicMetadata.putAll(subscriptionMetadata);
    }

    public Map<String, TopicMetadata> computeSubscriptionMetadata(Map<String, Integer> subscribedTopicNames, TopicsImage topicsImage, ClusterImage clusterImage) {
        HashMap newSubscriptionMetadata = new HashMap(subscribedTopicNames.size());
        subscribedTopicNames.forEach((topicName, count) -> {
            TopicImage topicImage = topicsImage.getTopic(topicName);
            if (topicImage != null) {
                HashMap<Integer, Set<String>> partitionRacks = new HashMap<Integer, Set<String>>();
                topicImage.partitions().forEach((partition, partitionRegistration) -> {
                    HashSet racks = new HashSet();
                    for (int replica : partitionRegistration.replicas) {
                        Optional rackOptional = clusterImage.broker(replica).rack();
                        rackOptional.ifPresent(racks::add);
                    }
                    if (!racks.isEmpty()) {
                        partitionRacks.put((Integer)partition, racks);
                    }
                });
                newSubscriptionMetadata.put(topicName, new TopicMetadata(topicImage.id(), topicImage.name(), topicImage.partitions().size(), partitionRacks));
            }
        });
        return Collections.unmodifiableMap(newSubscriptionMetadata);
    }

    public void setMetadataRefreshDeadline(long deadlineMs, int groupEpoch) {
        this.metadataRefreshDeadline = new DeadlineAndEpoch(deadlineMs, groupEpoch);
    }

    public void requestMetadataRefresh() {
        this.metadataRefreshDeadline = DeadlineAndEpoch.EMPTY;
    }

    public boolean hasMetadataExpired(long currentTimeMs) {
        return currentTimeMs >= this.metadataRefreshDeadline.deadlineMs || this.groupEpoch() < this.metadataRefreshDeadline.epoch;
    }

    public DeadlineAndEpoch metadataRefreshDeadline() {
        return this.metadataRefreshDeadline;
    }

    protected void maybeUpdateSubscribedTopicNamesAndGroupSubscriptionType(ModernGroupMember oldMember, ModernGroupMember newMember) {
        ModernGroup.maybeUpdateSubscribedTopicNames(this.subscribedTopicNames, oldMember, newMember);
        this.subscriptionType.set((Object)ModernGroup.subscriptionType(this.subscribedTopicNames, this.members.size()));
    }

    private static void maybeUpdateSubscribedTopicNames(Map<String, Integer> subscribedTopicCount, ModernGroupMember oldMember, ModernGroupMember newMember) {
        if (oldMember != null) {
            oldMember.subscribedTopicNames().forEach(topicName -> subscribedTopicCount.compute((String)topicName, Utils::decValue));
        }
        if (newMember != null) {
            newMember.subscribedTopicNames().forEach(topicName -> subscribedTopicCount.compute((String)topicName, Utils::incValue));
        }
    }

    public Map<String, Integer> computeSubscribedTopicNames(ModernGroupMember oldMember, ModernGroupMember newMember) {
        HashMap<String, Integer> subscribedTopicNames = new HashMap<String, Integer>((Map<String, Integer>)this.subscribedTopicNames);
        ModernGroup.maybeUpdateSubscribedTopicNames(subscribedTopicNames, oldMember, newMember);
        return subscribedTopicNames;
    }

    public Map<String, Integer> computeSubscribedTopicNames(Set<? extends ModernGroupMember> removedMembers) {
        HashMap<String, Integer> subscribedTopicNames = new HashMap<String, Integer>((Map<String, Integer>)this.subscribedTopicNames);
        if (removedMembers != null) {
            removedMembers.forEach(removedMember -> ModernGroup.maybeUpdateSubscribedTopicNames(subscribedTopicNames, removedMember, null));
        }
        return subscribedTopicNames;
    }

    public static SubscriptionType subscriptionType(Map<String, Integer> subscribedTopicNames, int numberOfMembers) {
        if (subscribedTopicNames.isEmpty()) {
            return SubscriptionType.HOMOGENEOUS;
        }
        for (int subscriberCount : subscribedTopicNames.values()) {
            if (subscriberCount == numberOfMembers) continue;
            return SubscriptionType.HETEROGENEOUS;
        }
        return SubscriptionType.HOMOGENEOUS;
    }

    public void removePartitionEpochs(Map<Uuid, Set<Integer>> assignment, int expectedEpoch) {
        assignment.forEach((topicId, assignedPartitions) -> this.currentPartitionEpoch.compute(topicId, (__, partitionsOrNull) -> {
            if (partitionsOrNull != null) {
                assignedPartitions.forEach(partitionId -> {
                    Integer prevValue = (Integer)partitionsOrNull.remove(partitionId);
                    if (prevValue != expectedEpoch) {
                        throw new IllegalStateException(String.format("Cannot remove the epoch %d from %s-%s because the partition is still owned at a different epoch %d", expectedEpoch, topicId, partitionId, prevValue));
                    }
                });
                if (partitionsOrNull.isEmpty()) {
                    return null;
                }
                return partitionsOrNull;
            }
            throw new IllegalStateException(String.format("Cannot remove the epoch %d from %s because it does not have any epoch", expectedEpoch, topicId));
        }));
    }

    public void addPartitionEpochs(Map<Uuid, Set<Integer>> assignment, int epoch) {
        assignment.forEach((topicId, assignedPartitions) -> this.currentPartitionEpoch.compute(topicId, (__, partitionsOrNull) -> {
            if (partitionsOrNull == null) {
                partitionsOrNull = new TimelineHashMap(this.snapshotRegistry, assignedPartitions.size());
            }
            for (Integer partitionId : assignedPartitions) {
                Integer prevValue = (Integer)partitionsOrNull.put((Object)partitionId, (Object)epoch);
                if (prevValue == null) continue;
                throw new IllegalStateException(String.format("Cannot set the epoch of %s-%s to %d because the partition is still owned at epoch %d", topicId, partitionId, epoch, prevValue));
            }
            return partitionsOrNull;
        }));
    }

    public abstract String protocolType();

    public abstract T getOrMaybeCreateMember(String var1, boolean var2);

    public abstract void updateMember(T var1);

    public abstract void removeMember(String var1);

    protected abstract void maybeUpdateGroupState();

    public static class DeadlineAndEpoch {
        static final DeadlineAndEpoch EMPTY = new DeadlineAndEpoch(0L, 0);
        public final long deadlineMs;
        public final int epoch;

        DeadlineAndEpoch(long deadlineMs, int epoch) {
            this.deadlineMs = deadlineMs;
            this.epoch = epoch;
        }
    }
}

