"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const concat_1 = require("rxjs/observable/concat");
const empty_1 = require("rxjs/observable/empty");
const from_1 = require("rxjs/observable/from");
const of_1 = require("rxjs/observable/of");
const operators_1 = require("rxjs/operators");
const update_buffer_1 = require("../utility/update-buffer");
const sink_1 = require("./sink");
class VirtualFileSystemSink extends sink_1.SimpleSinkBase {
    constructor(_host, _force = false) {
        super();
        this._host = _host;
        this._force = _force;
        this._filesToDelete = new Set();
        this._filesToRename = new Set();
        this._filesToCreate = new Map();
        this._filesToUpdate = new Map();
    }
    _validateCreateAction(action) {
        return this._force ? empty_1.empty() : super._validateCreateAction(action);
    }
    _validateFileExists(p) {
        if (this._filesToCreate.has(p) || this._filesToUpdate.has(p)) {
            return of_1.of(true);
        }
        else if (this._filesToDelete.has(p)) {
            return of_1.of(false);
        }
        else {
            return this._host.exists(p);
        }
    }
    _overwriteFile(path, content) {
        this._filesToUpdate.set(path, new update_buffer_1.UpdateBuffer(content));
        return empty_1.empty();
    }
    _createFile(path, content) {
        this._filesToCreate.set(path, new update_buffer_1.UpdateBuffer(content));
        return empty_1.empty();
    }
    _renameFile(from, to) {
        this._filesToRename.add([from, to]);
        return empty_1.empty();
    }
    _deleteFile(path) {
        if (this._filesToCreate.has(path)) {
            this._filesToCreate.delete(path);
            this._filesToUpdate.delete(path);
        }
        else {
            this._filesToDelete.add(path);
        }
        return empty_1.empty();
    }
    _done() {
        // Really commit everything to the actual filesystem.
        return concat_1.concat(from_1.from([...this._filesToDelete.values()]).pipe(operators_1.concatMap(path => this._host.delete(path))), from_1.from([...this._filesToCreate.entries()]).pipe(operators_1.concatMap(([path, buffer]) => this._host.write(path, buffer.generate()))), from_1.from([...this._filesToRename.entries()]).pipe(operators_1.concatMap(([_, [path, to]]) => this._host.rename(path, to))), from_1.from([...this._filesToUpdate.entries()]).pipe(operators_1.concatMap(([path, buffer]) => this._host.write(path, buffer.generate())))).pipe(operators_1.reduce(() => { }));
    }
}
exports.VirtualFileSystemSink = VirtualFileSystemSink;
//# sourceMappingURL=data:application/json;base64,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