/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/cdk/observers"),require("@angular/cdk/platform"),require("@angular/core"),require("@angular/material/core"),require("@angular/platform-browser"),require("@angular/cdk/a11y"),require("@angular/cdk/coercion"),require("@angular/forms")):"function"==typeof define&&define.amd?define(["exports","@angular/cdk/observers","@angular/cdk/platform","@angular/core","@angular/material/core","@angular/platform-browser","@angular/cdk/a11y","@angular/cdk/coercion","@angular/forms"],t):t((e.ng=e.ng||{},e.ng.material=e.ng.material||{},e.ng.material.slideToggle=e.ng.material.slideToggle||{}),e.ng.cdk.observers,e.ng.cdk.platform,e.ng.core,e.ng.material.core,e.ng.platformBrowser,e.ng.cdk.a11y,e.ng.cdk.coercion,e.ng.forms)}(this,function(e,t,i,n,r,a,o,l,s){"use strict";function d(e,t){function i(){this.constructor=e}g(e,t),e.prototype=null===t?Object.create(t):(i.prototype=t.prototype,new i)}var g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var i in t)t.hasOwnProperty(i)&&(e[i]=t[i])},c=0,u={provide:s.NG_VALUE_ACCESSOR,useExisting:n.forwardRef(function(){return b}),multi:!0},p=function(){function e(e,t){this.source=e,this.checked=t}return e}(),h=function(){function e(e){this._elementRef=e}return e}(),m=r.mixinTabIndex(r.mixinColor(r.mixinDisableRipple(r.mixinDisabled(h)),"accent")),b=function(e){function t(t,i,r,a,o){var l=e.call(this,t)||this;return l._platform=i,l._focusMonitor=r,l._changeDetectorRef=a,l.onChange=function(e){},l.onTouched=function(){},l._uniqueId="mat-slide-toggle-"+ ++c,l._required=!1,l._checked=!1,l.name=null,l.id=l._uniqueId,l.labelPosition="after",l.ariaLabel=null,l.ariaLabelledby=null,l.change=new n.EventEmitter,l.tabIndex=parseInt(o)||0,l}return d(t,e),Object.defineProperty(t.prototype,"required",{get:function(){return this._required},set:function(e){this._required=l.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"checked",{get:function(){return this._checked},set:function(e){this._checked=l.coerceBooleanProperty(e),this._changeDetectorRef.markForCheck()},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"inputId",{get:function(){return(this.id||this._uniqueId)+"-input"},enumerable:!0,configurable:!0}),t.prototype.ngAfterContentInit=function(){var e=this;this._slideRenderer=new f(this._elementRef,this._platform),this._focusMonitor.monitor(this._inputElement.nativeElement).subscribe(function(t){return e._onInputFocusChange(t)})},t.prototype.ngOnDestroy=function(){this._focusMonitor.stopMonitoring(this._inputElement.nativeElement)},t.prototype._onChangeEvent=function(e){if(e.stopPropagation(),this._slideRenderer.dragging)return void(this._inputElement.nativeElement.checked=this.checked);this.checked=this._inputElement.nativeElement.checked,this._emitChangeEvent()},t.prototype._onInputClick=function(e){e.stopPropagation()},t.prototype.writeValue=function(e){this.checked=!!e},t.prototype.registerOnChange=function(e){this.onChange=e},t.prototype.registerOnTouched=function(e){this.onTouched=e},t.prototype.setDisabledState=function(e){this.disabled=e,this._changeDetectorRef.markForCheck()},t.prototype.focus=function(){this._focusMonitor.focusVia(this._inputElement.nativeElement,"keyboard")},t.prototype.toggle=function(){this.checked=!this.checked},t.prototype._onInputFocusChange=function(e){this._focusRipple||"keyboard"!==e?e||(this.onTouched(),this._focusRipple&&(this._focusRipple.fadeOut(),this._focusRipple=null)):this._focusRipple=this._ripple.launch(0,0,{persistent:!0})},t.prototype._emitChangeEvent=function(){this.onChange(this.checked),this.change.emit(new p(this,this.checked))},t.prototype._onDragStart=function(){this.disabled||this._slideRenderer.startThumbDrag(this.checked)},t.prototype._onDrag=function(e){this._slideRenderer.dragging&&this._slideRenderer.updateThumbPosition(e.deltaX)},t.prototype._onDragEnd=function(){var e=this;if(this._slideRenderer.dragging){var t=this._slideRenderer.dragPercentage>50;t!==this.checked&&(this.checked=t,this._emitChangeEvent()),setTimeout(function(){return e._slideRenderer.stopThumbDrag()})}},t.prototype._onLabelTextChange=function(){this._changeDetectorRef.markForCheck()},t.decorators=[{type:n.Component,args:[{selector:"mat-slide-toggle",exportAs:"matSlideToggle",host:{class:"mat-slide-toggle","[id]":"id","[class.mat-checked]":"checked","[class.mat-disabled]":"disabled","[class.mat-slide-toggle-label-before]":'labelPosition == "before"'},template:'<label class="mat-slide-toggle-label" #label><div class="mat-slide-toggle-bar" [class.mat-slide-toggle-bar-no-side-margin]="!labelContent.textContent || !labelContent.textContent.trim()"><input #input class="mat-slide-toggle-input cdk-visually-hidden" type="checkbox" [id]="inputId" [required]="required" [tabIndex]="tabIndex" [checked]="checked" [disabled]="disabled" [attr.name]="name" [attr.aria-label]="ariaLabel" [attr.aria-labelledby]="ariaLabelledby" (change)="_onChangeEvent($event)" (click)="_onInputClick($event)"><div class="mat-slide-toggle-thumb-container" (slidestart)="_onDragStart()" (slide)="_onDrag($event)" (slideend)="_onDragEnd()"><div class="mat-slide-toggle-thumb"></div><div class="mat-slide-toggle-ripple" mat-ripple [matRippleTrigger]="label" [matRippleDisabled]="disableRipple || disabled" [matRippleCentered]="true" [matRippleRadius]="23" [matRippleAnimation]="{enterDuration: 150}"></div></div></div><span class="mat-slide-toggle-content" #labelContent (cdkObserveContent)="_onLabelTextChange()"><ng-content></ng-content></span></label>',styles:[".mat-slide-toggle{display:inline-block;height:24px;max-width:100%;line-height:24px;white-space:nowrap;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;outline:0}.mat-slide-toggle.mat-checked .mat-slide-toggle-thumb-container{transform:translate3d(16px,0,0)}.mat-slide-toggle.mat-disabled .mat-slide-toggle-label,.mat-slide-toggle.mat-disabled .mat-slide-toggle-thumb-container{cursor:default}.mat-slide-toggle-label{display:flex;flex:1;flex-direction:row;align-items:center;height:inherit;cursor:pointer}.mat-slide-toggle-content{white-space:nowrap;overflow:hidden;text-overflow:ellipsis}.mat-slide-toggle-label-before .mat-slide-toggle-label{order:1}.mat-slide-toggle-label-before .mat-slide-toggle-bar{order:2}.mat-slide-toggle-bar,[dir=rtl] .mat-slide-toggle-label-before .mat-slide-toggle-bar{margin-right:8px;margin-left:0}.mat-slide-toggle-label-before .mat-slide-toggle-bar,[dir=rtl] .mat-slide-toggle-bar{margin-left:8px;margin-right:0}.mat-slide-toggle-bar-no-side-margin{margin-left:0;margin-right:0}.mat-slide-toggle-thumb-container{position:absolute;z-index:1;width:20px;height:20px;top:-3px;left:0;transform:translate3d(0,0,0);transition:all 80ms linear;transition-property:transform;cursor:-webkit-grab;cursor:grab}.mat-slide-toggle-thumb-container.mat-dragging,.mat-slide-toggle-thumb-container:active{cursor:-webkit-grabbing;cursor:grabbing;transition-duration:0s}.mat-slide-toggle-thumb{height:20px;width:20px;border-radius:50%;box-shadow:0 2px 1px -1px rgba(0,0,0,.2),0 1px 1px 0 rgba(0,0,0,.14),0 1px 3px 0 rgba(0,0,0,.12)}@media screen and (-ms-high-contrast:active){.mat-slide-toggle-thumb{background:#fff;border:solid 1px #000}}.mat-slide-toggle-bar{position:relative;width:36px;height:14px;flex-shrink:0;border-radius:8px}@media screen and (-ms-high-contrast:active){.mat-slide-toggle-bar{background:#fff}}.mat-slide-toggle-input{bottom:0;left:10px}.mat-slide-toggle-bar,.mat-slide-toggle-thumb{transition:all 80ms linear;transition-property:background-color;transition-delay:50ms}.mat-slide-toggle-ripple{position:absolute;top:calc(50% - 23px);left:calc(50% - 23px);height:46px;width:46px;z-index:1;pointer-events:none}"],providers:[u],inputs:["disabled","disableRipple","color","tabIndex"],encapsulation:n.ViewEncapsulation.None,preserveWhitespaces:!1,changeDetection:n.ChangeDetectionStrategy.OnPush}]}],t.ctorParameters=function(){return[{type:n.ElementRef},{type:i.Platform},{type:o.FocusMonitor},{type:n.ChangeDetectorRef},{type:void 0,decorators:[{type:n.Attribute,args:["tabindex"]}]}]},t.propDecorators={name:[{type:n.Input}],id:[{type:n.Input}],labelPosition:[{type:n.Input}],ariaLabel:[{type:n.Input,args:["aria-label"]}],ariaLabelledby:[{type:n.Input,args:["aria-labelledby"]}],required:[{type:n.Input}],checked:[{type:n.Input}],change:[{type:n.Output}],_inputElement:[{type:n.ViewChild,args:["input"]}],_ripple:[{type:n.ViewChild,args:[r.MatRipple]}]},t}(m),f=function(){function e(e,t){this.dragging=!1,t.isBrowser&&(this._thumbEl=e.nativeElement.querySelector(".mat-slide-toggle-thumb-container"),this._thumbBarEl=e.nativeElement.querySelector(".mat-slide-toggle-bar"))}return e.prototype.startThumbDrag=function(e){this.dragging||(this._thumbBarWidth=this._thumbBarEl.clientWidth-this._thumbEl.clientWidth,this._thumbEl.classList.add("mat-dragging"),this._previousChecked=e,this.dragging=!0)},e.prototype.stopThumbDrag=function(){return!!this.dragging&&(this.dragging=!1,this._thumbEl.classList.remove("mat-dragging"),this._thumbEl.style.transform="",this.dragPercentage>50)},e.prototype.updateThumbPosition=function(e){this.dragPercentage=this._getDragPercentage(e);var t=this.dragPercentage/100*this._thumbBarWidth;this._thumbEl.style.transform="translate3d("+t+"px, 0, 0)"},e.prototype._getDragPercentage=function(e){var t=e/this._thumbBarWidth*100;return this._previousChecked&&(t+=100),Math.max(0,Math.min(t,100))},e}(),_=function(){function e(){}return e.decorators=[{type:n.NgModule,args:[{imports:[r.MatRippleModule,r.MatCommonModule,i.PlatformModule,t.ObserversModule,o.A11yModule],exports:[b,r.MatCommonModule],declarations:[b],providers:[{provide:a.HAMMER_GESTURE_CONFIG,useClass:r.GestureConfig}]}]}],e.ctorParameters=function(){return[]},e}();e.MatSlideToggleModule=_,e.MAT_SLIDE_TOGGLE_VALUE_ACCESSOR=u,e.MatSlideToggleChange=p,e.MatSlideToggleBase=h,e._MatSlideToggleMixinBase=m,e.MatSlideToggle=b,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=material-slide-toggle.umd.min.js.map
