"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const schematics_1 = require("@angular-devkit/schematics");
const semver = require("semver");
const npm_1 = require("../utility/npm");
const angularDevkitPackagesName = [
    '@angular-devkit/core',
    '@angular-devkit/schematics',
    '@angular-devkit/build-optimizer',
];
function default_1(options) {
    const version = options.version || 'latest';
    if (semver.valid(version)) {
        throw new schematics_1.SchematicsException('You cannot specify a version, you need to use a dist tag.');
    }
    return npm_1.updatePackageJson(angularDevkitPackagesName, options.version, options.loose);
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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