/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.table;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.knox.gateway.shell.table.KnoxShellTableBuilder;
import org.apache.knox.gateway.shell.table.KnoxShellTableCall;
import org.apache.knox.gateway.shell.table.KnoxShellTableCallHistory;
import org.apache.knox.gateway.shell.table.KnoxShellTableFilter;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class KnoxShellTableHistoryAspect {
    private static final String KNOX_SHELL_TYPE = "org.apache.knox.gateway.shell.table.KnoxShellTable";

    @Pointcut(value="execution(public org.apache.knox.gateway.shell.table.KnoxShellTableFilter org.apache.knox.gateway.shell.table.KnoxShellTable.filter(..))")
    public void knoxShellTableCreateFilterPointcut() {
    }

    @Pointcut(value="execution(public * org.apache.knox.gateway.shell.table.*KnoxShellTableBuilder.*(..))")
    public void knoxShellTableBuilderPointcut() {
    }

    @Pointcut(value="execution(public * org.apache.knox.gateway.shell.table.*KnoxShellTableFilter.*(..))")
    public void knoxShellTableFilterPointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="org.apache.knox.gateway.shell.table.KnoxShellTableHistoryAspect.knoxShellTableCreateFilterPointcut()")
    public KnoxShellTableFilter whenCreatingFilter(ProceedingJoinPoint joinPoint) throws Throwable {
        KnoxShellTableFilter filter = null;
        try {
            KnoxShellTableFilter knoxShellTableFilter = filter = (KnoxShellTableFilter)joinPoint.proceed();
            return knoxShellTableFilter;
        }
        finally {
            if (filter != null) {
                this.saveKnoxShellTableCall((JoinPoint)joinPoint, filter.filteredTable.id);
            }
        }
    }

    @After(value="org.apache.knox.gateway.shell.table.KnoxShellTableHistoryAspect.knoxShellTableBuilderPointcut()")
    public void afterBuilding(JoinPoint joinPoint) throws Throwable {
        long builderId = ((KnoxShellTableBuilder)joinPoint.getTarget()).table.id;
        this.saveKnoxShellTableCall(joinPoint, builderId);
    }

    @After(value="org.apache.knox.gateway.shell.table.KnoxShellTableHistoryAspect.knoxShellTableFilterPointcut()")
    public void afterFiltering(JoinPoint joinPoint) throws Throwable {
        long builderId = ((KnoxShellTableFilter)joinPoint.getTarget()).filteredTable.id;
        this.saveKnoxShellTableCall(joinPoint, builderId);
    }

    private void saveKnoxShellTableCall(JoinPoint joinPoint, long builderId) {
        Signature signature = joinPoint.getSignature();
        boolean builderMethod = KNOX_SHELL_TYPE.equals(((MethodSignature)signature).getReturnType().getCanonicalName());
        HashMap params = new HashMap();
        Arrays.stream(joinPoint.getArgs()).forEach(param -> params.put(param, param.getClass()));
        KnoxShellTableCallHistory.getInstance().saveCall(builderId, new KnoxShellTableCall(signature.getDeclaringTypeName(), signature.getName(), builderMethod, params));
    }
}

