/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree.serializer;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.directory.mavibot.btree.comparator.StringComparator;
import org.apache.directory.mavibot.btree.exception.SerializerCreationException;
import org.apache.directory.mavibot.btree.serializer.AbstractElementSerializer;
import org.apache.directory.mavibot.btree.serializer.BufferHandler;
import org.apache.directory.mavibot.btree.serializer.IntSerializer;
import org.apache.directory.mavibot.btree.util.Strings;

public class StringSerializer
extends AbstractElementSerializer<String> {
    public static final StringSerializer INSTANCE = new StringSerializer();

    private StringSerializer() {
        super(StringComparator.INSTANCE);
    }

    public StringSerializer(Comparator<String> comparator) {
        super(comparator);
    }

    public static String deserialize(byte[] in) {
        return StringSerializer.deserialize(in, 0);
    }

    public static String deserialize(byte[] in, int start) {
        int length = IntSerializer.deserialize(in, start);
        if (length == -1) {
            return null;
        }
        if (in.length < length + 4 + start) {
            throw new SerializerCreationException("Cannot extract a String from a buffer with not enough bytes");
        }
        return Strings.utf8ToString(in, start + 4, length);
    }

    @Override
    public String fromBytes(byte[] in) {
        return StringSerializer.deserialize(in, 0);
    }

    @Override
    public String fromBytes(byte[] in, int start) {
        int length = IntSerializer.deserialize(in, start);
        if (length == -1) {
            return null;
        }
        if (in.length < length + start) {
            throw new SerializerCreationException("Cannot extract a String from a buffer with not enough bytes");
        }
        return Strings.utf8ToString(in, start + 4, length);
    }

    public static byte[] serialize(byte[] buffer, int start, String element) {
        int len = -1;
        if (element != null) {
            len = element.length();
        }
        switch (len) {
            case 0: {
                buffer[start] = 0;
                buffer[start + 1] = 0;
                buffer[start + 2] = 0;
                buffer[start + 3] = 0;
                break;
            }
            case -1: {
                buffer[start] = -1;
                buffer[start + 1] = -1;
                buffer[start + 2] = -1;
                buffer[start + 3] = -1;
                break;
            }
            default: {
                try {
                    byte[] strBytes = element.getBytes("UTF-8");
                    buffer = new byte[strBytes.length + 4];
                    System.arraycopy(strBytes, 0, buffer, 4, strBytes.length);
                    buffer[start] = (byte)(strBytes.length >>> 24);
                    buffer[start + 1] = (byte)(strBytes.length >>> 16);
                    buffer[start + 2] = (byte)(strBytes.length >>> 8);
                    buffer[start + 3] = (byte)strBytes.length;
                    break;
                }
                catch (UnsupportedEncodingException uee) {
                    throw new SerializerCreationException(uee);
                }
            }
        }
        return buffer;
    }

    @Override
    public byte[] serialize(String element) {
        int len = -1;
        if (element != null) {
            len = element.length();
        }
        byte[] bytes = null;
        switch (len) {
            case 0: {
                bytes = new byte[]{0, 0, 0, 0};
                break;
            }
            case -1: {
                bytes = new byte[]{-1, -1, -1, -1};
                break;
            }
            default: {
                char[] chars = element.toCharArray();
                byte[] tmpBytes = new byte[chars.length * 2];
                int pos = 0;
                len = 0;
                for (char c : chars) {
                    if ((c & 0xFF80) == 0) {
                        tmpBytes[pos++] = (byte)c;
                        continue;
                    }
                    if ((c & 0xF800) == 0) {
                        tmpBytes[pos++] = (byte)(0xFFFFFFC0 | (byte)((c & 0x7C0) >> 6));
                        tmpBytes[pos++] = (byte)(0xFFFFFF80 | (byte)(c & 0x3F));
                        continue;
                    }
                    tmpBytes[pos++] = (byte)(0xFFFFFF80 | (byte)(c & 0x1F));
                    tmpBytes[pos++] = (byte)(0xFFFFFF80 | (byte)(c & 0x7C0));
                    tmpBytes[pos++] = (byte)(0xFFFFFFE0 | (byte)(c & 0x7800));
                }
                bytes = new byte[pos + 4];
                bytes[0] = (byte)(pos >>> 24);
                bytes[1] = (byte)(pos >>> 16);
                bytes[2] = (byte)(pos >>> 8);
                bytes[3] = (byte)pos;
                System.arraycopy(tmpBytes, 0, bytes, 4, pos);
            }
        }
        return bytes;
    }

    @Override
    public String deserialize(BufferHandler bufferHandler) throws IOException {
        byte[] in = bufferHandler.read(4);
        int len = IntSerializer.deserialize(in);
        switch (len) {
            case 0: {
                return "";
            }
            case -1: {
                return null;
            }
        }
        in = bufferHandler.read(len);
        return Strings.utf8ToString(in);
    }

    @Override
    public String deserialize(ByteBuffer buffer) throws IOException {
        int len = buffer.getInt();
        switch (len) {
            case 0: {
                return "";
            }
            case -1: {
                return null;
            }
        }
        byte[] bytes = new byte[len];
        buffer.get(bytes);
        char[] chars = new char[len];
        int clen = 0;
        for (int i = 0; i < len; ++i) {
            byte b2;
            byte b = bytes[i];
            if (b >= 0) {
                chars[clen++] = (char)b;
                continue;
            }
            if ((b & 0xE0) == 0) {
                b2 = bytes[++i];
                byte b3 = bytes[++i];
                chars[clen++] = (char)((b & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
                continue;
            }
            b2 = bytes[++i];
            chars[clen++] = (char)((b & 0x1F) << 6 | b2 & 0x3F);
        }
        return new String(chars, 0, clen);
    }

    @Override
    public int compare(String type1, String type2) {
        if (type1 == type2) {
            return 0;
        }
        if (type1 == null) {
            if (type2 == null) {
                return 0;
            }
            return -1;
        }
        if (type2 == null) {
            return 1;
        }
        return type1.compareTo(type2);
    }
}

