/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.filter.GatewayResponseWrapper;

public class CookieScopeResponseWrapper
extends GatewayResponseWrapper {
    private static final String SET_COOKIE = "Set-Cookie";
    private static final String COOKIE_PATH = "Path=/";
    private final String scopePath;

    public CookieScopeResponseWrapper(HttpServletResponse response, String gatewayPath) {
        super(response);
        this.scopePath = COOKIE_PATH + this.generateIfValidSegment(gatewayPath);
    }

    public CookieScopeResponseWrapper(HttpServletResponse response, String gatewayPath, String topologyName) {
        super(response);
        this.scopePath = COOKIE_PATH + this.generateIfValidSegment(gatewayPath) + this.generateIfValidSegment(topologyName);
    }

    public void addHeader(String name, String value) {
        if (SET_COOKIE.equals(name)) {
            String updatedCookie = value.contains(COOKIE_PATH) ? value.replace(COOKIE_PATH, this.scopePath) : String.format(Locale.ROOT, "%s %s;", value, this.scopePath);
            super.addHeader(name, updatedCookie);
        } else {
            super.addHeader(name, value);
        }
    }

    public OutputStream getRawOutputStream() throws IOException {
        return this.getResponse().getOutputStream();
    }

    private String generateIfValidSegment(String pathSegment) {
        if (pathSegment == null || pathSegment.isEmpty() || "/".equals(pathSegment)) {
            return "";
        }
        return pathSegment + "/";
    }
}

