/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiClusterRef;
import com.cloudera.api.swagger.model.ApiCommandList;
import com.cloudera.api.swagger.model.ApiHostRef;
import com.cloudera.api.swagger.model.ApiRoleRef;
import com.cloudera.api.swagger.model.ApiServiceRef;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="Provides detailed information about a submitted command.  <p>There are two types of commands: synchronous and asynchronous. Synchronous commands complete immediately, and their results are passed back in the returned command object after the execution of an API call. Outside of that returned object, there is no way to check the result of a synchronous command.</p>  <p>Asynchronous commands have unique non-negative IDs. They may still be running when the API call returns. Clients can check the status of such commands using the API.</p>")
public class ApiCommand {
    @SerializedName(value="id")
    private BigDecimal id = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="startTime")
    private String startTime = null;
    @SerializedName(value="endTime")
    private String endTime = null;
    @SerializedName(value="active")
    private Boolean active = null;
    @SerializedName(value="success")
    private Boolean success = null;
    @SerializedName(value="resultMessage")
    private String resultMessage = null;
    @SerializedName(value="resultDataUrl")
    private String resultDataUrl = null;
    @SerializedName(value="clusterRef")
    private ApiClusterRef clusterRef = null;
    @SerializedName(value="serviceRef")
    private ApiServiceRef serviceRef = null;
    @SerializedName(value="roleRef")
    private ApiRoleRef roleRef = null;
    @SerializedName(value="hostRef")
    private ApiHostRef hostRef = null;
    @SerializedName(value="parent")
    private ApiCommand parent = null;
    @SerializedName(value="children")
    private ApiCommandList children = null;
    @SerializedName(value="canRetry")
    private Boolean canRetry = null;

    public ApiCommand id(BigDecimal id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The command ID.")
    public BigDecimal getId() {
        return this.id;
    }

    public void setId(BigDecimal id) {
        this.id = id;
    }

    public ApiCommand name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The command name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiCommand startTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(value="The start time.")
    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public ApiCommand endTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(value="The end time, if the command is finished.")
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public ApiCommand active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(value="Whether the command is currently active.")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public ApiCommand success(Boolean success) {
        this.success = success;
        return this;
    }

    @ApiModelProperty(value="If the command is finished, whether it was successful.")
    public Boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public ApiCommand resultMessage(String resultMessage) {
        this.resultMessage = resultMessage;
        return this;
    }

    @ApiModelProperty(value="If the command is finished, the result message.")
    public String getResultMessage() {
        return this.resultMessage;
    }

    public void setResultMessage(String resultMessage) {
        this.resultMessage = resultMessage;
    }

    public ApiCommand resultDataUrl(String resultDataUrl) {
        this.resultDataUrl = resultDataUrl;
        return this;
    }

    @ApiModelProperty(value="URL to the command's downloadable result data, if any exists.")
    public String getResultDataUrl() {
        return this.resultDataUrl;
    }

    public void setResultDataUrl(String resultDataUrl) {
        this.resultDataUrl = resultDataUrl;
    }

    public ApiCommand clusterRef(ApiClusterRef clusterRef) {
        this.clusterRef = clusterRef;
        return this;
    }

    @ApiModelProperty(value="Reference to the cluster (for cluster commands only).")
    public ApiClusterRef getClusterRef() {
        return this.clusterRef;
    }

    public void setClusterRef(ApiClusterRef clusterRef) {
        this.clusterRef = clusterRef;
    }

    public ApiCommand serviceRef(ApiServiceRef serviceRef) {
        this.serviceRef = serviceRef;
        return this;
    }

    @ApiModelProperty(value="Reference to the service (for service commands only).")
    public ApiServiceRef getServiceRef() {
        return this.serviceRef;
    }

    public void setServiceRef(ApiServiceRef serviceRef) {
        this.serviceRef = serviceRef;
    }

    public ApiCommand roleRef(ApiRoleRef roleRef) {
        this.roleRef = roleRef;
        return this;
    }

    @ApiModelProperty(value="Reference to the role (for role commands only).")
    public ApiRoleRef getRoleRef() {
        return this.roleRef;
    }

    public void setRoleRef(ApiRoleRef roleRef) {
        this.roleRef = roleRef;
    }

    public ApiCommand hostRef(ApiHostRef hostRef) {
        this.hostRef = hostRef;
        return this;
    }

    @ApiModelProperty(value="Reference to the host (for host commands only).")
    public ApiHostRef getHostRef() {
        return this.hostRef;
    }

    public void setHostRef(ApiHostRef hostRef) {
        this.hostRef = hostRef;
    }

    public ApiCommand parent(ApiCommand parent) {
        this.parent = parent;
        return this;
    }

    @ApiModelProperty(value="Reference to the parent command, if any.")
    public ApiCommand getParent() {
        return this.parent;
    }

    public void setParent(ApiCommand parent) {
        this.parent = parent;
    }

    public ApiCommand children(ApiCommandList children) {
        this.children = children;
        return this;
    }

    @ApiModelProperty(value="List of child commands. Only available in the full view. <p> The list contains only the summary view of the children.")
    public ApiCommandList getChildren() {
        return this.children;
    }

    public void setChildren(ApiCommandList children) {
        this.children = children;
    }

    public ApiCommand canRetry(Boolean canRetry) {
        this.canRetry = canRetry;
        return this;
    }

    @ApiModelProperty(value="If the command can be retried. Available since V11")
    public Boolean getCanRetry() {
        return this.canRetry;
    }

    public void setCanRetry(Boolean canRetry) {
        this.canRetry = canRetry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiCommand apiCommand = (ApiCommand)o;
        return Objects.equals(this.id, apiCommand.id) && Objects.equals(this.name, apiCommand.name) && Objects.equals(this.startTime, apiCommand.startTime) && Objects.equals(this.endTime, apiCommand.endTime) && Objects.equals(this.active, apiCommand.active) && Objects.equals(this.success, apiCommand.success) && Objects.equals(this.resultMessage, apiCommand.resultMessage) && Objects.equals(this.resultDataUrl, apiCommand.resultDataUrl) && Objects.equals(this.clusterRef, apiCommand.clusterRef) && Objects.equals(this.serviceRef, apiCommand.serviceRef) && Objects.equals(this.roleRef, apiCommand.roleRef) && Objects.equals(this.hostRef, apiCommand.hostRef) && Objects.equals(this.parent, apiCommand.parent) && Objects.equals(this.children, apiCommand.children) && Objects.equals(this.canRetry, apiCommand.canRetry);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.startTime, this.endTime, this.active, this.success, this.resultMessage, this.resultDataUrl, this.clusterRef, this.serviceRef, this.roleRef, this.hostRef, this.parent, this.children, this.canRetry);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiCommand {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    success: ").append(this.toIndentedString(this.success)).append("\n");
        sb.append("    resultMessage: ").append(this.toIndentedString(this.resultMessage)).append("\n");
        sb.append("    resultDataUrl: ").append(this.toIndentedString(this.resultDataUrl)).append("\n");
        sb.append("    clusterRef: ").append(this.toIndentedString(this.clusterRef)).append("\n");
        sb.append("    serviceRef: ").append(this.toIndentedString(this.serviceRef)).append("\n");
        sb.append("    roleRef: ").append(this.toIndentedString(this.roleRef)).append("\n");
        sb.append("    hostRef: ").append(this.toIndentedString(this.hostRef)).append("\n");
        sb.append("    parent: ").append(this.toIndentedString(this.parent)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    canRetry: ").append(this.toIndentedString(this.canRetry)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

